/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef BOMB_H
#define BOMB_H

#include "projectile.h"

#define BOMB_STR std::string("bomb")


class Sprite;


/* Bomp - implements the projectile type that is affected by viscosity of the media
    - does not adapt its angle to the motion direction
*/
class Bomb : public Projectile {
public:
	Bomb(const TiXmlElement* Att, float Scale = 1.f);

	virtual void OnUpdate();
	//Do nothing because there is nothing that can change here. Media resistance is calculated also
	//on the client
	virtual void CheckData() {};
	virtual void GetChangedData(MessageCoder &MC) const {};

	const ULONG GetTypeID() const {return GEN_ID('b', 'o', 'm', 'b');}

private:
	Sprite *BaseSprite;

	virtual void Damage(const PhysicalObject *Obj);
};


#endif
