/***************************************************************************
 *   Copyright (C) 2004 by Milan Mimica                                    *
 *   milan.mimica@gmail.com                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef AMMO_PACK_H
#define AMMO_PACK_H

#define AMMO_PACK_STR std::string("ammo_pack")

#include "player_object.h"

#include "initializer.h"

#include "grant_object.h"


/* AmmoPack - implements ammonition package
*/
class AmmoPack : public IncrecreaseObject {
public:
	AmmoPack(const TiXmlElement* Att , float Scale = 1.f);

	virtual const ULONG GetTypeID() const {return GEN_ID('a', 'm', 'p', 'k');}

private:
	virtual bool Increcrease(PlayerObject* PlaObj);

	USHORT WeaponIndex;
	USHORT AmmoCount;
};

DECLARE_FACTORY(AmmoPack, Object)

#endif
