#ifndef READMAP9_C
#define READMAP9_C

#include "readmap9.h"
#include <stdio.h>

void Level_Malloc() {
	level = (unsigned char *) malloc((unsigned long) MAX_LEVEL_SIZE);
	if (level == NULL) {
		printf("Can't allocate memory for level.\n");
		exit(1);
	}
		else printf("Memory for level allocated.\n");
}

void Clear_Level() {
	long int i;
	for (i=0; i<MAX_LEVEL_SIZE; i++)
		level[i] = 0;
   transparency = 0;
   relative_scroll_rate = 0;
   rise_rate = 0;
   start_spot_x = 0;
   start_spot_y = 0;
   start_spot_z = 0;
   how_player_enters = 0;
   walk_to_spot_x = 0;
   walk_to_spot_y = 0;
   walk_to_spot_z = 0;
   how_player_exits = 0;
   left_end_type = 0;
   left_end_slant = 0;
   left_end_offset = 0;
   right_end_type = 0;
   right_end_slant = 0;
   right_end_offset = 0;
   top_end_type = 0;
   top_end_z = 0;
   bottom_end_type = 0;
   bottom_end_z = 0;
   color_cycle_low_end = 0;
   color_cycle_high_end = 0;
   color_cycle_speed = 0;
   music_num = 0;
   }

void Clear_Trans_Table() {
     int index;
     for (index = 0; index < TILE_COUNT; index++)
         trans_table[index] = 1;
     }

void Load_Trans_Table(char *file_name) {
	FILE *fp;//, *fopen();
	int index = 0;
	printf("Loading *%s* trans table..\n", file_name );
	fp = fopen(file_name,"rb");
	Clear_Trans_Table();
	while (index < TILE_COUNT) {
        	trans_table[index] = getc(fp);
		index++;
	}
	fclose(fp);
}

char * lstr( char * f ){
	char * bn = f;
	while ( *bn != '\0' ){
		if ( *bn >= 'A' && *bn <= 'Z' )
			*bn = *bn - 'A' + 'a';
		bn++;
	}
	return f;
}

void Load_Map(char * file_name){
	FILE *fp; //, *fopen();
	int index = 0;
	int index2 = 0;
	int found_dot = 0;
	char * trans_table_name;
	unsigned char c;
	trans_table_name = malloc( sizeof( char ) * 14 );
	//printf("Load map function\n");
	//printf("number %d\n", file_name );
	//printf("File name is %p\n", file_name );
	//printf("First char %c\n", *file_name );
	printf("Loading map %s\n", file_name );
	fp = fopen(file_name,"rb");
	// 254=EOF in Timap encoding; 255=end of row
	Clear_Level();
	printf("Cleared level..\n");
	num_rows = 0;
	row_length = 0;
	while  ((c = getc(fp)) != 254) {
		if (c == 255) {
			num_rows++;
			row_length=index-1;
			index = 0;
		} else
			level[index2++] = c;
		index++;
	}
	for (index = 0; index < MAX_TRIGGER_POINTS; index++) {
		trigger_points[index].stop_scroll = getc(fp);
		trigger_points[index].xcoord = ((int) getc(fp)) << 8;
		trigger_points[index].xcoord |= (int) getc(fp);
		trigger_points[index].max_at_once = getc(fp);
		trigger_points[index].total_badguys = getc(fp);
		for (index2 = 0; index2 < 16; index2++) {
			trigger_points[index].badguy[index2].who = getc(fp);
			trigger_points[index].badguy[index2].how = getc(fp);
			trigger_points[index].badguy[index2].dif = getc(fp);
			trigger_points[index].badguy[index2].where_x = ((short)getc(fp)) << 8;
			trigger_points[index].badguy[index2].where_x |= (short)getc(fp);
			trigger_points[index].badguy[index2].where_y = ((short)getc(fp)) << 8;
			trigger_points[index].badguy[index2].where_y |= (short)getc(fp);
			trigger_points[index].badguy[index2].where_z = ((short)getc(fp)) << 8;
			trigger_points[index].badguy[index2].where_z |= (short)getc(fp);
		}
	}
	tile_file_name = malloc( sizeof( char ) * 14 );
	for (index = 0; index < 13; index++) {
		tile_file_name[index]=getc(fp);
	}
	   tile_file_name[13] = '\0'; // This is what we call defensive programming!
	   printf("Using *%s* tile set\n", tile_file_name );
	   tile_file_name = lstr( tile_file_name );
	for (index = 0; index < 13; index++) {
		next_file_name[index]=getc(fp);
	}
	
	next_file_name[12] = '\0';

	bkgd_file_name = malloc( sizeof( char ) * 13 );
	for (index = 0; index < 13; index++) {
		bkgd_file_name[index]=getc(fp);
	}
	bkgd_file_name[12] = '\0';
	bkgd_file_name = lstr( bkgd_file_name );

	transparency = getc(fp);
	relative_scroll_rate = getc(fp);
	rise_rate = getc(fp);
	start_spot_x = ((short)getc(fp)) << 8;
	start_spot_x |= (short)getc(fp);
	start_spot_y = ((short)getc(fp)) << 8;
	start_spot_y |= (short)getc(fp);
	start_spot_z = ((short)getc(fp)) << 8;
	start_spot_z |= (short)getc(fp);
	how_player_enters = getc(fp);
	walk_to_spot_x = ((short)getc(fp)) << 8;
	walk_to_spot_x |= (short)getc(fp);
	walk_to_spot_y = ((short)getc(fp)) << 8;
	walk_to_spot_y |= (short)getc(fp);
	walk_to_spot_z = ((short)getc(fp)) << 8;
	walk_to_spot_z |= (short)getc(fp);
	how_player_exits = getc(fp);
	left_end_type = getc(fp);
	left_end_slant = getc(fp);
	left_end_offset = ((short)getc(fp)) << 8;
	left_end_offset |= (short)getc(fp);
	right_end_type = getc(fp);
	right_end_slant = getc(fp);
	right_end_offset = ((short)getc(fp)) << 8;
	right_end_offset |= (short)getc(fp);
	top_end_type = getc(fp);
	top_end_z = getc(fp);
	bottom_end_type = getc(fp);
	bottom_end_z = getc(fp);
	color_cycle_low_end = getc(fp);
	color_cycle_high_end = getc(fp);
	color_cycle_speed = getc(fp);
	music_num = getc(fp);
	fclose(fp);

//if ((_access(tile_file_name, 0)) != -1) // That is, if the file exists...
	printf("Loading tile set..\n");
	Load_Tile_Set(tile_file_name);
	printf("Loaded tile set..\n");
//if ((_access(bkgd_file_name, 0)) != -1)
	bg_pic = load_pcx(bkgd_file_name,scrap_palette);
	index = 0;
	while (!found_dot) {
		if (tile_file_name[index] == '.' || tile_file_name[index] == 0 || index > 12) {
			if (index > 8)
				index = 8;
			
			trans_table_name[index] = '.';
			trans_table_name[index+1] = 't';
			trans_table_name[index+2] = 'r';
			trans_table_name[index+3] = 'a';
			trans_table_name[index+4] = 0;
			found_dot = 1;
		} else
			trans_table_name[index] = tile_file_name[index];
		index++;
	}
	trans_table_name[ 13 ] = '\0';
	printf("Loading trans table..\n");
//if ((_access(trans_table_name, 0)) != -1)
	trans_table_name = lstr( trans_table_name );
	Load_Trans_Table(trans_table_name);
	printf("Successfully loaded map\n");
//else
//    Clear_Trans_Table();
}

#endif
