#include "rat.h"
#include "nsdefs.h"
#include "sprfxnns.h"
#include <allegro.h>

extern sprite *player[];
int r;

void Do_Rat_AI(sprite_ptr spr) {
   if (spr->curr_state == STANDING) {
      if (TARGET->x < spr->x)
         spr->flipflag = FLIP;
      else
          spr->flipflag = NOFLIP;
      if (Within_Range(spr, attacks[4])) {
            r=rand() % 100;
            if ((SPRITE_DIRECTION) == (TARGET_DIRECTION)) {
               if (r < 80) {
                  FA_Set_State(spr, ATTACK1);
                  }
               else {
                  FA_Set_State(spr, PAUSING);
                  }
               }
            else {
                 if (r < 60) {
                    FA_Set_State(spr, ATTACK1);
                    }
                 else if (r < 80) {
                      FA_Set_State(spr, HOP_AWAY);
                      }
                 }
            }
         else {
               r=rand() % 100;
               if (r<5)
					   FA_Set_State(spr, HOP_TOWARD);
               else if (r==5)
                  FA_Set_State(spr, HOP_AWAY);
               else
                  FA_Set_State(spr, APPROACH);
               }
      } // end STANDING
   if (spr->curr_state == PAUSING) {
      spr->curr_frame = 6;
      spr->x_velocity = 0;
      spr->y_velocity = 0;
      spr->z_velocity = 0;
      if (TARGET->x < spr->x)
				spr->flipflag = FLIP;
			else
				spr->flipflag = NOFLIP;
			spr->action_count++;
			if (spr->action_count == 105) {
				spr->action_count = 0;
				if (TARGET->x - spr->x > -65 && TARGET->x - spr->x < 65)
					FA_Set_State(spr, HOP_AWAY);
				else {
               r=rand() % 100;
               if (r<5)
					   FA_Set_State(spr, HOP_TOWARD);
               else if (r==5)
                  FA_Set_State(spr, HOP_AWAY);
               else
                  FA_Set_State(spr, APPROACH);
               }
				}
         if (Within_Range(spr, attacks[4])) {
            r=rand() % 100;
            if ((TARGET_DIRECTION) == (SPRITE_DIRECTION)) {
               if (r < 3) {
                  FA_Set_State(spr, ATTACK1);
                  }
               }
            else {
               if (r < 2) {
                  FA_Set_State(spr, ATTACK1);
                  }
               else if (r == 2) {
                  FA_Set_State(spr, HOP_AWAY);
                  }
               }
            }
      } // end PAUSING
   if (spr->curr_state == LEANING) {
      spr->hit_direction = 0;
      spr->flipflag = NOFLIP;
      if (spr->x < TARGET->x + 20) {
         FA_Set_State(spr, STANDING);
         }
      } // end LEANING
   if (spr->curr_state == APPROACH) {
         spr->curr_anim = 4;
         if (spr->action_count == 0) {
            if (TARGET->x < spr->x)
				   spr->flipflag = FLIP;
            else
				   spr->flipflag = NOFLIP;
            }
			if (spr->flipflag == FLIP)
				spr->x_velocity = -4 * (24-abs(spr->action_count-24));
			else
				spr->x_velocity = 4 * (24-abs(spr->action_count-24));
         if (spr->action_count == 0) {
				spr->z_velocity = (1 * (TARGET->z - spr->z));
				}
         if (spr->z_velocity > 40)
            spr->z_velocity = 40;
         if (spr->z_velocity < -40)
            spr->z_velocity = -40;
         if (Within_Range(spr, attacks[4])) {
            r = rand() % 100;
            if ((TARGET_DIRECTION) == (SPRITE_DIRECTION)) {
               if (r < 3) {
                  FA_Set_State(spr, ATTACK1);
                  }
               }
            else {
               if (r < 2) {
                  FA_Set_State(spr, ATTACK1);
                  }
                  else if (r == 2) {
                  FA_Set_State(spr, HOP_AWAY);
                  }
               }
            }
         spr->action_count++;
			if (spr->action_count == 48) {
            r=rand() % 100;
            if (r<87)
               FA_Set_State(spr, APPROACH);
            else if (r<95)
               FA_Set_State(spr, PAUSING);
            else
               FA_Set_State(spr, HOP_TOWARD);
				}
         } // end APPROACH
      if (spr->curr_state == HOP_TOWARD) {
			if (spr->flipflag == FLIP)
				spr->x_velocity = -100;
			else
				spr->x_velocity = 100;
			spr->y_velocity = -90 + (spr->action_count*GRAVITY);
			if (spr->action_count == 0) {
				spr->z_velocity = (1 * (TARGET->z - spr->z));
				}
			spr->action_count++;
			spr->curr_frame = 143;
			if (spr->y == 0 && spr->y_velocity > 0) {
				FA_Set_State(spr, STANDING);
            }
         } // end HOP_TOWARD
		if (spr->curr_state == HOP_AWAY) {
			if (spr->flipflag == FLIP)
				spr->x_velocity = 150;
			else
				spr->x_velocity = -150;
			spr->y_velocity = -90 + (spr->action_count*GRAVITY);
			spr->z_velocity = 0;
			spr->action_count++;
			spr->curr_frame = 143;
			if (spr->y == 0 && spr->y_velocity > 0) {
				spr->curr_state = STANDING;
				spr->action_count = 0;
				}
         } // end HOP_AWAY
      if (spr->curr_state == ATTACK1) {

         } // end ATTACK1
		if (spr->curr_state == WALK_DOWN) {
			if (spr->x > TARGET->x)
				spr->flipflag = FLIP;
			else
				spr->flipflag = NOFLIP;
         spr->z_velocity = 40;
         spr->curr_anim = 4;
         if (spr->z >= 144 || spr->z >= TARGET->z) {
				FA_Set_State(spr, STANDING);
            }
         } // end WALK_DOWN
      if (spr->curr_state == WALK_UP) {
			if (spr->x > TARGET->x)
				spr->flipflag = FLIP;
			else
				spr->flipflag = NOFLIP;
         spr->z_velocity = -40;
         spr->curr_anim = 4;
         if (spr->z <= 184 || spr->z <= TARGET->z) {
				FA_Set_State(spr, STANDING);
            }
         } // end WALK_UP
   }

void Handle_Rat(sprite_ptr spr) {
   if (spr->curr_state == LEANING) {
      spr->curr_frame = 131;
      }
   if (spr->curr_state == WALKING) {
      spr->curr_anim = 4;
      if (spr->action_count > 47)
         spr->action_count = 0;
      if (spr->h == -1) {
         spr->flipflag = FLIP;
         spr->x_velocity = -4 * (24-abs(spr->action_count-24));
         }
      if (spr->h == 1) {
         spr->flipflag = NOFLIP;
         spr->x_velocity = 4 * (24-abs(spr->action_count-24));
         }
      if (spr->h == 0) {
         spr->x_velocity = 0;
         }
      if (spr->v == -1) {
         spr->z_velocity = -40;
         }
      if (spr->v == 1) {
         spr->z_velocity = 40;
         }
      if (spr->v == 0) {
         spr->z_velocity = 0;
         }
      spr->action_count++;
      }
   if (spr->curr_state == JUMP_ATTACK) {
      spr->curr_state = JUMPING;
      }
   if (spr->curr_state == JUMPING) {
         spr->curr_frame = 143;
			spr->y_velocity = (-18 + spr->action_count) * GRAVITY;
         spr->x_velocity = 150 * spr->h;
			spr->action_count++;
         if (spr->y_velocity > 0 && spr->y == 0)
				FA_Set_State(spr, STANDING);
         }
   if (spr->curr_state == SPECIAL) {
      FA_Set_State(spr, ATTACK1);
      spr->var1 = 0;
      }	
   if (spr->curr_state == ATTACK5) {
      FA_Set_State(spr, ATTACK1);
      spr->var1 = 0;
      }
   if (spr->curr_state == ATTACK4) {
      FA_Set_State(spr, ATTACK1);
      spr->var1 = 0;
      }
   if (spr->curr_state == ATTACK3) {
      FA_Set_State(spr, ATTACK1);
      spr->var1 = 0;
      }
   if (spr->curr_state == ATTACK2) {
      FA_Set_State(spr, ATTACK1);
      spr->var1 = 0;
      }
   if (spr->curr_state == ATTACK1) {
      spr->x_velocity = 0;
      spr->y_velocity = 0;
      spr->z_velocity = 0;
      spr->curr_anim = 5;
      if (spr->anim_done)
         FA_Set_State(spr, STANDING);
      }
   if (spr->curr_state == HELD1) {
		spr->curr_frame = 11;
		if (spr->hold->curr_state == HOLDING && spr->action_count == 280) {
			FA_Set_State(spr->hold, STANDING);
			FA_Set_State(spr, DROP_FREE);
			spr->hold->hold = NULL;
			spr->hold = NULL;
			}
		spr->action_count++;
		}
   if (spr->curr_state == HELD2) {
		spr->curr_frame = 7;
		if (spr->hold->curr_state == HOLDING && spr->action_count == 280) {
			FA_Set_State(spr->hold, STANDING);
			FA_Set_State(spr, DROP_FREE);
			spr->hold->hold = NULL;
			spr->hold = NULL;
			}
		spr->action_count++;
		}
   /* if (spr->curr_state == DROP_FREE) {
	   spr->y_velocity = (spr->action_count * GRAVITY);
	   spr->action_count++;
	   if (spr->y == 0) {
		   FA_Set_State(spr, STANDING);
			}
		} */
   if (spr->curr_state == GET_HIT_STOMACH) {
      spr->curr_frame = 7;
      if (spr->controlled_by == CPU_ENEMY)
         if (spr->action_count == 70) {
            FA_Set_State(spr, STANDING);
            spr->hit_direction = 0;
            }
      }
   if (spr->curr_state == GET_HIT_HEAD) {
      spr->curr_frame = 11;
      if (spr->controlled_by == CPU_ENEMY)
         if (spr->action_count == 70) {
            FA_Set_State(spr, STANDING);
            spr->hit_direction = 0;
            }
      }
   if (spr->curr_state == THROWN) {
		spr->curr_frame = 8;
		}
   if (spr->curr_state == KNOCKED_DOWN) {
      spr->curr_frame = 8;
      }
   if (spr->curr_state == ON_GROUND_BRIEF || spr->curr_state == ON_GROUND || spr->curr_state == DEAD) {
      spr->curr_frame = 9;
      }
   if (spr->curr_state == BOUNCE) {
      spr->curr_frame = 10;
      }
   if (spr->curr_state == ON_GROUND) {
      if (spr->action_count == 90) {
         FA_Set_State(spr, GET_UP);
         spr->hit_direction = 0;
         }
      spr->action_count++;
      }
   if (spr->curr_state == GET_UP) {
         if (spr->action_count < 26)
         spr->curr_frame = 14;
         else if (spr->action_count < 51)
         spr->curr_frame = 9;
         else if (spr->action_count < 91)
         spr->curr_frame = 14;
         else if (spr->action_count < 131)
         spr->curr_frame = 12;
         else {
              FA_Set_State(spr, STANDING);
              }
			spr->action_count++;
			}
   if (spr->curr_state == STANDING) {
      spr->curr_frame = 6;
      }
   if (spr->curr_state == WAIT_FOR_NEXT_LIFE) {
      spr->curr_frame = 6;
      }
   }

