#include <stdio.h>
//#include <conio.h>
//#include <dos.h>
#include <string.h>
//#include <io.h>
#include <malloc.h>
#include <allegro.h>
#include "nsdefs.h"
#include "trigger.h"
#include "sprite8.h"
#include "badguy.h"
#include "scrnfunx.h"
#include "tilefunx.h"
#include "readmap9.h"
#include "scrollnu.h"
#include "sprfxnns.h"
#include "enbarns.h"
#include "ns1dat.h"
#include "handler.h"

#include <ctype.h>

#define NORTH 0
#define EAST 1
#define SOUTH 2
#define WEST 3
#define JUMP 4
#define STRIKE 5


/* Globals */
FILE *logfile, *fopen();
DATAFILE *ns1_data;
FONT *big_font;
sprite sprites[MAX_SPRITES];
sprite ** player;
//sprite * player[MAX_PLAYERS];
sprite_ptr priority_table[MAX_SPRITES];
sprite menu_arrow;
char *start_maps[8] = {"stalk1a.nsm","stalk2a.nsm","stalk3a.nsm","stalk4o.nsm","stalk5a.nsm","stalk2a.nsm","stalk2a.nsm","stalk2a.nsm"};
char *stage_names[8] = {"DA 'HOOD","LAB","WOODS","CLUB","FACTORY","","",""}; // AIRFIELD,TOWER,MAXINE'S MANSION
int en_bar_time[MAX_SPRITES];
int num_bars_drawn = 0;
int whose_bar[MAX_BARS];
int num_x_moves, num_y_moves, num_z_moves, move_counter;
unsigned char scroll_lock = 0;
unsigned char stand_by = 1;
// unsigned char player_hit = 0; // whether player hit somebody on current frame
int on_trigger = -1;
int next_trigger = 0;
int curr_enemy = 0;
unsigned char difficulty_level = 2;
int players_in_game;
int mission_number = 1;
int enemies_on_screen = 0;
unsigned char debug_info = 0;
int enemy_info = 0;
unsigned char log_mode = 0;
unsigned char show_boxes = 0;
unsigned char paused = 0;
unsigned char show_status = 0;
int curr_music = 0;
long score[MAX_PLAYERS];
int lives[MAX_PLAYERS];
int continues[MAX_PLAYERS];
int continue_timer[MAX_PLAYERS];
char *state_names[] = {"STANDING","JUMPING","ATTACK1","ATTACK2","ATTACK3","ATTACK4","ATTACK5","GET HIT HEAD","GET HIT STOMACH","KNOCKED DOWN","ON GROUND","ON GROUND BRIEF","BOUNCE","DEAD","INACTIVE","HOP TOWARD","HOP AWAY","GET UP","WALK DOWN","WALK UP","CHARGING","DOUBLE JUMP","DROP","LEANING","SITTING","KNEELING AWAY","KNEELING FORWARD","KNEELING TOWARD","APPROACH","RETREAT","PAUSING","GET BEHIND","Z ADJUST","WALKING","BLINK OUT"};
char *switch_states[2] = {"OFF", "ON"};
trigger trigger_points[MAX_TRIGGER_POINTS];
short controls[MAX_PLAYERS][6];
BITMAP *shad;
unsigned char shadows_on = 1;

/* External variables */
extern int row_length;
extern int num_rows;
extern unsigned char *level;
extern char * tile_file_name;
extern char next_file_name[];
extern int start_x;
extern int start_y; /* upper left corner of screen, tells
			      Draw_Screen where to start drawing from */
extern char *sprite_data;
extern char *frame_ptrs[MAX_FRAMES];
extern unsigned short anim_seqs[MAX_ANIMATIONS][19];
extern FONT *curr_font;
extern char trans_table[];
extern char * bkgd_file_name;
extern unsigned char transparency;
extern char relative_scroll_rate;
extern char rise_rate;
extern short start_spot_x;
extern short start_spot_y;
extern short start_spot_z;
extern unsigned char how_player_enters;
extern short walk_to_spot_x;
extern short walk_to_spot_y;
extern short walk_to_spot_z;
extern unsigned char how_player_exits;
extern unsigned char left_end_type;
extern char left_end_slant;
extern short left_end_offset;
extern unsigned char right_end_type;
extern char right_end_slant;
extern short right_end_offset;
extern char top_end_type;
extern unsigned char top_end_z;
extern char bottom_end_type;
extern unsigned char bottom_end_z;
extern unsigned char color_cycle_low_end;
extern unsigned char color_cycle_high_end;
extern unsigned char color_cycle_speed;

int Get_Press(int numkey) {
   static char key_tracker[128];
   if (!key[numkey]) {
      key_tracker[numkey] = 0;
      return 0;
      }
   else {
      if (key_tracker[numkey] == 1)
         return 0;
      else {
         key_tracker[numkey] = 1;
         return 1;
         }
      }
   }

void Copy_Attributes(int enemy_num, int badguy_num) {
   sprites[enemy_num].name = badguylist[badguy_num].name;
	sprites[enemy_num].health = badguylist[badguy_num].stamina;
	sprites[enemy_num].max_health = badguylist[badguy_num].stamina;
	sprites[enemy_num].invulnerable_flag = 0;
	sprites[enemy_num].palnum = badguylist[badguy_num].palookup;
	sprites[enemy_num].type = badguylist[badguy_num].badguy_type;
	sprites[enemy_num].lvl = badguylist[badguy_num].strength_level;
   sprites[enemy_num].controlled_by = CPU_ENEMY;
	sprites[enemy_num].curr_state = STANDING;
   }

void Draw_Collision_Box(sprite_ptr spr) {
   short xs, xe, ys, ye;
   if (spr->type == NO_TYPE || spr->curr_frame == -1)
	   return;
   if (spr->flipflag == NOFLIP) {
      xs = (unsigned char)frame_ptrs[spr->curr_frame][4] << 8;
      xs |= (unsigned char)frame_ptrs[spr->curr_frame][5];
      xs += (spr->x-start_x);
      xe = (unsigned char)frame_ptrs[spr->curr_frame][6] << 8;
      xe |= (unsigned char)frame_ptrs[spr->curr_frame][7];
      xe += (spr->x-start_x);
      ys = (spr->y-start_y)+spr->z+(((unsigned char)frame_ptrs[spr->curr_frame][8] << 8) | ((unsigned char)frame_ptrs[spr->curr_frame][9]));
      ye = (spr->y-start_y)+spr->z+(((unsigned char)frame_ptrs[spr->curr_frame][10] << 8) | ((unsigned char)frame_ptrs[spr->curr_frame][11]));
      }
   else {
      xs = (spr->x-start_x)-(((unsigned char)frame_ptrs[spr->curr_frame][6] << 8) | ((unsigned char)frame_ptrs[spr->curr_frame][7]));
      xe = (spr->x-start_x)-(((unsigned char)frame_ptrs[spr->curr_frame][4] << 8) | ((unsigned char)frame_ptrs[spr->curr_frame][5]));
      ys = (spr->y-start_y)+spr->z+(((unsigned char)frame_ptrs[spr->curr_frame][8] << 8) | ((unsigned char)frame_ptrs[spr->curr_frame][9]));
      ye = (spr->y-start_y)+spr->z+(((unsigned char)frame_ptrs[spr->curr_frame][10] << 8) | ((unsigned char)frame_ptrs[spr->curr_frame][11]));
      }
   if (xs > (SCREEN_WIDTH-1) || xe < 0)
      return;
   if (ys > (SCREEN_HEIGHT-1) || ye < 0)
      return;
   hline(double_buffer,xs,ys,xe,65);
   hline(double_buffer,xs,ye,xe,65);
   vline(double_buffer,xs,ys,ye,65);
   vline(double_buffer,xe,ys,ye,65);
   }

int Is_Player(int s) {
   int i;
   for (i=0; i<MAX_PLAYERS; i++) {
      if (player[i] == &sprites[s])
      return 1;
      }
   return 0;
   }

void Count_Enemies() {
	int i, j = 0;
	for (i=0;i<MAX_SPRITES;i++) {
      if (!Is_Player(i))
		   if (sprites[i].type == RAT || sprites[i].type == BOAR || sprites[i].type == WEASEL || sprites[i].type == CHEETAH || sprites[i].type == DUCK || sprites[i].type == ELK || sprites[i].type == SALAMANDER || sprites[i].type == KOALA || sprites[i].type == TURTLE || sprites[i].type == FLUFFY || sprites[i].type == RHINO || sprites[i].type == SHELLY || sprites[i].type == OPIE || sprites[i].type == OMAR || sprites[i].type == GERRI || sprites[i].type == CASTOR || sprites[i].type == MAXINE || sprites[i].type == MEL)
			   j++;
		}
	enemies_on_screen = j;
	}

void Write_PCX() {
	char pcx_file_name[13];
	int found_usable_file_name = 0;
	int pcx_count = 0;
	int i,j;
	while (!found_usable_file_name) {
		strcpy(pcx_file_name,"STALK000.PCX");
		pcx_file_name[5] = (pcx_count / 100)+'0';
		pcx_file_name[6] = ((pcx_count % 100) / 10)+'0';
		pcx_file_name[7] = (pcx_count % 10)+'0';
      // Warning! Code may break if you save > 1000 .PCX files!
		found_usable_file_name = 1;
      /*(
      if ((_access(pcx_file_name, 0)) == -1)
         found_usable_file_name = 1;
      else
          pcx_count++;
      if (pcx_count == 1000)
         return; // Limit of 1000 screenshots reached
	*/
	}
	save_pcx(pcx_file_name,screen,ns1_data[ns1_pal].dat);
}

void Init_All_Players() {
	int i;
	for (i=0; i<MAX_PLAYERS; i++) {
		player[i] = NULL;
	}
	for (i=0; i<players_in_game; i++) {
		player[i] = &sprites[i];
		FA_Set_State(player[i],STANDING);
		Place_Sprite(player[i], start_spot_x+(i*10), start_spot_y, start_spot_z+(i*10));
		player[i]->curr_frame = 0;
		player[i]->curr_anim = 0;
		player[i]->type = LENNY;
		player[i]->palnum = 0;
		player[i]->controlled_by = HUMAN;
		player[i]->health = 100;
		player[i]->max_health = 100;
		}
	player[0]->name = "LENNY";
	if (players_in_game > 1)
		player[1]->name = "WAYNE";
	if (players_in_game > 2)
		player[2]->name = "PETEY";
	if (players_in_game > 3)
		player[3]->name = "GEOFF";
}

void Menu() {
   int menu_number = 1;
   int menu_selection = 0;
   menu_arrow.curr_frame = 37;
   while (menu_number) {
      clear(double_buffer);
      if (Get_Press(KEY_UP))
         if (menu_selection > 0)
            menu_selection--;
      if (Get_Press(KEY_DOWN))
         menu_selection++;
      if (menu_number == 1) {
         if (menu_selection > 2)
            menu_selection = 2;
         textout_centre(double_buffer,big_font,"NIGHT STALKERS",160,0,-1);
         textout(double_buffer,big_font,"START NEW GAME",48,24,-1);
         textout(double_buffer,big_font,"OPTIONS",48,40,-1);
         textout(double_buffer,big_font,"QUIT",48,56,-1);
		 textout_centre(double_buffer,curr_font,"Version 0.1 - Designed and programmed by Tim Nolan",160,170,-1);
		 /*textout_centre(double_buffer,curr_font,"Based on characters created by",160,180,-1);
		 textout_centre(double_buffer,curr_font,"Tim Nolan and Kevin Santangelo",160,190,-1); */
         if (Get_Press(KEY_ENTER)) {
            if (menu_selection == 0) {
               menu_number = 4;
               }
            if (menu_selection == 1) {
               menu_number = 3;
               }
            if (menu_selection == 2) {
               exit(0);
               }
            }
         }
      if (menu_number == 2) {
         if (menu_selection > 2)
            menu_selection = 2;
         textout_centre(double_buffer,big_font,"DIFFICULTY LEVEL",160,0,-1);
         textout(double_buffer,big_font,"EASY",48,24,-1);
         textout(double_buffer,big_font,"MEDIUM",48,40,-1);
         textout(double_buffer,big_font,"HARD",48,56,-1);
         if (Get_Press(KEY_ENTER)) {
            difficulty_level = menu_selection;
            menu_number = 0;
            }
         if (Get_Press(KEY_ESC)) {
            menu_number = 1;
            }
         }
      if (menu_number == 3) {
         if (menu_selection > 3)
            menu_selection = 3;
         textout_centre(double_buffer,big_font,"OPTIONS",160,0,-1);
         textout(double_buffer,big_font,"SOUND",48,24,-1);
         textout(double_buffer,big_font,"GAMMA CORRECTION",48,40,-1);
         textout(double_buffer,big_font,"CONTROLS",48,56,-1);
		 textprintf(double_buffer,big_font,48,72,-1,"SHADOWS %s",switch_states[shadows_on]);
		 if (Get_Press(KEY_ENTER)) {
            if (menu_selection == 3) {
               if (shadows_on)
				   shadows_on = 0;
			   else
				   shadows_on = 1;
               }
			}
		 if (Get_Press(KEY_ESC)) {
            menu_number = 1;
            }
         }
	  if (menu_number == 4) {
         if (menu_selection > 3)
            menu_selection = 3;
         textout_centre(double_buffer,big_font,"NUMBER OF PLAYERS",160,0,-1);
         textout(double_buffer,big_font,"1 PLAYER",48,24,-1);
         textout(double_buffer,big_font,"2 PLAYERS",48,40,-1);
         textout(double_buffer,big_font,"3 PLAYERS",48,56,-1);
		 textout(double_buffer,big_font,"4 PLAYERS",48,72,-1);
		 if (Get_Press(KEY_ENTER)) {
            players_in_game = menu_selection + 1;
			if (players_in_game > MAX_PLAYERS) {
				players_in_game = MAX_PLAYERS;
				}
			menu_number = 2;
			}
		 if (Get_Press(KEY_ESC)) {
            menu_number = 1;
            }
         }
	  menu_arrow.x=start_x+24;
      menu_arrow.y=24+(menu_selection*16);
      menu_arrow.z=0;
      Blit_Sprite((sprite_ptr)&menu_arrow);
      //vsync();
      		stretch_blit(double_buffer,screen,0,0,320,200,0,0,640,480);
	}
   Init_All_Players();
   }

void Set_Priflags() {
	int i;
	for (i = 0; i < MAX_SPRITES; i++) {
		sprites[i].priflag = ((sprites[i].z * 1000) + ((sprites[i].type == EFFECT)? 250 : 0) + i - (((sprites[i].curr_state == HELD1) || (sprites[i].curr_state == HELD2) || (sprites[i].curr_state == HELD3))? 500 : 0));
		}
	}

void priswap(sprite_ptr spr[], int i, int j) {
	sprite_ptr temp;
	temp = spr[i];
	spr[i] = spr[j];
	spr[j] = temp;
	}

void prisort(sprite_ptr spr[], int left, int right) {
	int i, last;
	if (left >= right)
		return;
	priswap(spr, left, (left + right)/2);
	last = left;
	for (i = left+1; i <= right; i++) {
		if (spr[i]->priflag < spr[left]->priflag) {
			priswap(spr, ++last, i);
			}
	/*	else if (spr[i]->z == spr[left]->z) {
			if  {
				priswap(spr, ++last, i);
				}
			else if (spr[i] < spr[left]) {
				priswap(spr, ++last, i);
				}
			} */
		}
	priswap(spr, left, last);
	prisort(spr, left, last-1);
	prisort(spr, last+1, right);
	}

void Play_Current_Music() {
	return;
   switch (music_num) {
      case 0:
           play_looped_midi(ns1_data[didnt_forget].dat, 1, -1);
           break;
      case 1:
           play_looped_midi(ns1_data[stomp_down].dat, 5, -1);
           break;
      case 2:
           play_looped_midi(ns1_data[fluffy_theme].dat, 1, -1);
           break;
      case 3:
           play_looped_midi(ns1_data[rock_tumbler].dat, 1, -1);
           break;
      case 4:
           play_looped_midi(ns1_data[fig].dat, 9, -1);
           break;
      case 5:
           play_looped_midi(ns1_data[say_not].dat, 1, -1);
           break;
      case 6:
           play_looped_midi(ns1_data[boss_c].dat, 1, -1);
           break;
      case 7:
           play_looped_midi(ns1_data[m_train].dat, 1, -1);
           break;
	  case 8:
			play_looped_midi(ns1_data[dinner_roll].dat, 17, -1);
			break;
      default:
           play_looped_midi(ns1_data[didnt_forget].dat, 1, -1);
           break;
      }
   }

int No_Other_Players(int num_player) {
   int x=1;
   int i;
   for (i=0; i<MAX_PLAYERS; i++) {
      if ((i != num_player) && (player[i] != NULL)) {
         x=0;
         }
      }
   return x;
   }

int Who_Did_It(sprite_ptr spr) {
	int i;
	if (spr == NULL) {
		score[1] -= 5000;
		}
	for (i=0; i<MAX_PLAYERS; i++) {
		if (spr == player[i]) {
			return i;
			}
		}
	return 0;
	}

void Score_Dead_Enemy(sprite_ptr spr, int sc) {
	if (spr->type == RAT)
		score[sc] += 500 + (spr->lvl * 100);
	else if (spr->type == BOAR)
		score[sc] += 800 + (spr->lvl * 200);
	else if (spr->type == FLUFFY)
		score[sc] += 2000 + (spr->lvl * 200);
	else if (spr->type == WEASEL)
		score[sc] += 600 + (spr->lvl * 100);
	else if (spr->type == KOALA)
		score[sc] += 400 + (spr->lvl * 100);
	else if (spr->type == ELK)
		score[sc] += 1200 + (spr->lvl * 300);
	}

void Game_Over() {
   int i, j;
   clear(double_buffer);
   textprintf_centre(double_buffer, big_font, 160, 92, -1, "GAME OVER");
	//vsync();
	stretch_blit(double_buffer,screen,0,0,320,200,0,0,640,480);
   for (i=0; i<280; i++)
       vsync();
   for (i=0; i<MAX_SPRITES; i++)
		Sprite_Init((sprite_ptr)&sprites[i]);
   for (j=0; j<MAX_PLAYERS; j++) {
       score[j] = 0;
       lives[j] = 3;
       continues[j] = 3;
       if (player[j] != NULL) {
          Place_Sprite(player[j], 24, 0, 164);
	       player[j]->health = 100;
          FA_Set_State(player[j], STANDING);
          player[j]->flipflag = NOFLIP;
          }
       }
   Load_Map(start_maps[0]);
   mission_number = 1;
   scroll_lock = 0;
   on_trigger = -1;
   next_trigger = 0;
   curr_enemy = 0;
   enemies_on_screen = 0;
   start_x = 0;
   start_y = 0;
   Menu();
   stand_by = 4;
   Play_Current_Music();
   }

void init( void ){
	allegro_init();
	Level_Malloc();
	Clear_Level();
}

void main(int argc, char *argv[]) {
   int i,j;
   int found_frame;
   int frame_loc;
   FILE *bugtrack;
   RGB black = {0,0,0};
   RGB *blackptr = &black;
   char * fn;
   player = malloc( sizeof(sprite *) * MAX_PLAYERS );
   init();
   bugtrack=fopen("bugtrack.txt","wt");
   
   //fprintf(bugtrack,"Program started running.\n");
   //fprintf(bugtrack,"Allegro initialized successfully.\n");
   //fprintf(bugtrack,"Memory allocated for level.\n");
   //fprintf(bugtrack,"Level memory cleared.\n");

   fn = "stalk1a.nsm";
   Load_Map( fn );
   //Load_Map("stalk1a.nsm");

   //fprintf(bugtrack,"Map loaded.\n");
   //printf("Map loaded\n");
   
   if (argv[1] != NULL) {
	  if (strcmp(argv[1],"-l") == 0) {
		log_mode = 1;
		logfile=fopen("ns1log.txt","wt");
		}
	  }
   if (log_mode) {
	fprintf(logfile,"Map stalk1a.nsm loaded.\n");
	} 
   //fprintf(bugtrack,"Command-line parameters parsed.\n");
   ns1_data = load_datafile("ns1.dat");
   curr_font = ns1_data[ns1_font].dat;
   big_font = ns1_data[ns1_big_font].dat;
   fprintf(bugtrack,"Main datafile loaded and fonts set.\n");
   fclose(bugtrack);
   text_mode(-1);
   printf("Loading frames..\n");
   Load_Frames("stalkers.nff");
   Sprite_Init((sprite_ptr)&menu_arrow);
   for (i=0; i<MAX_SPRITES; i++)
		Sprite_Init((sprite_ptr)&sprites[i]);
   start_x = 0;
   start_y = 0;
   for (i=0; i<MAX_PLAYERS; i++) {
       lives[i] = 3;
       score[i] = 0;
       continues[i] = 3;
       }
   for (i=0; i<MAX_BARS; i++) {
      whose_bar[i] = -1;
      en_bar_time[i] = 0;
      }
   for (i=0; i<MAX_SPRITES; i++) {
      priority_table[i] = (sprite_ptr)&sprites[i];
      }
   // stand_by = 0;
   controls[0][NORTH] = KEY_UP;
   controls[0][EAST] = KEY_RIGHT;
   controls[0][SOUTH] = KEY_DOWN;
   controls[0][WEST] = KEY_LEFT;
   controls[0][JUMP] = KEY_ALT;
   controls[0][STRIKE] = KEY_LCONTROL;
   controls[1][NORTH] = KEY_HOME;
   controls[1][EAST] = KEY_PGDN;
   controls[1][SOUTH] = KEY_END;
   controls[1][WEST] = KEY_DEL;
   controls[1][JUMP] = KEY_0;
   controls[1][STRIKE] = KEY_9;
   controls[2][NORTH] = KEY_SLASH_PAD;
   controls[2][EAST] = KEY_9_PAD;
   controls[2][SOUTH] = KEY_8_PAD;
   controls[2][WEST] = KEY_7_PAD;
   controls[2][JUMP] = KEY_F12;
   controls[2][STRIKE] = KEY_F11;
   controls[3][NORTH] = KEY_5_PAD;
   controls[3][EAST] = KEY_3_PAD;
   controls[3][SOUTH] = KEY_2_PAD;
   controls[3][WEST] = KEY_1_PAD;
   controls[3][JUMP] = KEY_PGUP;
   controls[3][STRIKE] = KEY_INSERT;
	Init_Double_Buffer();
	set_gfx_mode(GFX_AUTODETECT_WINDOWED,640,480,640,480);
	install_keyboard();
   install_timer();
   if (install_sound(DIGI_AUTODETECT, MIDI_NONE, "") != 0) {
      printf("Error initializing sound system\n%s\n", allegro_error);
      return;
      }
   set_palette(ns1_data[ns1_pal].dat);
   shad = load_bitmap("shadow.pcx", null_palette);
   clear(screen);
   Menu();
   printf("Loading game..\n");
   //Init_All_Players();
   Play_Current_Music();
   stand_by = 4;

	while (!key[KEY_ESC]) {
		for ( i = 0; i < players_in_game; i++) {
			if ( player[i] != NULL) {
				if (!stand_by) {
         				if (key[controls[i][EAST]] || key[controls[i][WEST]] || key[controls[i][NORTH]] || key[controls[i][SOUTH]]) {
            					if (player[i]->curr_state == STANDING) {
					               FA_Set_State(player[i], WALKING);
						}
            if (player[i]->curr_state == WALKING) {
               if (key[controls[i][EAST]]) {
                  player[i]->h = 1;
                  }
               if (key[controls[i][WEST]]) {
                  player[i]->h = -1;
                  }
               if (key[controls[i][EAST]] && key[controls[i][WEST]]) {
                  player[i]->h = 0;
                  }
               if (!key[controls[i][EAST]] && !key[controls[i][WEST]]) {
                  player[i]->h = 0;
                  }
               if (key[controls[i][SOUTH]]) {
                  player[i]->v = 1;
                  }
               if (key[controls[i][NORTH]]) {
                  player[i]->v = -1;
                  }
               if (key[controls[i][SOUTH]] && key[controls[i][NORTH]]) {
                  player[i]->v = 0;
                  }
               if (!key[controls[i][SOUTH]] && !key[controls[i][NORTH]]) {
                  player[i]->v = 0;
                  }
               }
            }
         if (!key[controls[i][EAST]] && !key[controls[i][WEST]] && !key[controls[i][NORTH]] && !key[controls[i][SOUTH]]) {
            if (player[i]->curr_state == WALKING) {
               FA_Set_State(player[i], STANDING);
               }
            }
		 if (Get_Press(controls[i][JUMP])) {
			 if ((key[controls[i][STRIKE]]) && ((player[i]->curr_state == ATTACK1 || player[i]->curr_state == ATTACK2 || player[i]->curr_state == ATTACK3 || player[i]->curr_state == ATTACK4 || player[i]->curr_state == ATTACK5) && (player[i]->frame_counter <= 3))) {
				player[i]->health -= 9;
				if (player[i]->health < 1) {
					player[i]->health = 1;
					}
				FA_Set_State(player[i], SPECIAL);
				}
            else if (player[i]->curr_state == STANDING || player[i]->curr_state == WALKING) {
               FA_Set_State(player[i], JUMPING);
               }
            }
         if (Get_Press(controls[i][STRIKE])) {
			 if ((key[controls[i][JUMP]]) && (player[i]->curr_state == JUMPING) && (player[i]->action_count < 3)) {
				player[i]->health -= 9;
				if (player[i]->health < 1) {
					player[i]->health = 1;
					}
				FA_Set_State(player[i], SPECIAL);
				}

            else if (player[i]->curr_state == STANDING || player[i]->curr_state == WALKING) {
               switch (player[i]->var1) {
                  case 0:
                       FA_Set_State(player[i], ATTACK1);
                       break;
                  case 1:
                       FA_Set_State(player[i], ATTACK2);
                       break;
                  case 2:
                       FA_Set_State(player[i], ATTACK3);
                       break;
                  case 3:
                       FA_Set_State(player[i], ATTACK4);
                       break;
                  case 4:
                       FA_Set_State(player[i], ATTACK5);
                       break;
                  default:
                       FA_Set_State(player[i], ATTACK1);
                       break;
                  }
               }
            if (player[i]->curr_state == JUMPING) {
               player[i]->frame_counter = 0;
               player[i]->curr_state = JUMP_ATTACK;
               }
			if (player[i]->curr_state == HOLDING || player[i]->curr_state == WALKING_HOLD) {
				if (key[controls[i][EAST]] || key[controls[i][WEST]]) {
					if (key[controls[i][EAST]]) {
						player[i]->h = 1;
						player[i]->flipflag = NOFLIP;
						}
					else if (key[controls[i][WEST]]) {
						player[i]->h = -1;
						player[i]->flipflag = FLIP;
						}
					FA_Set_State(player[i], THROWING);
					}
				else {
					FA_Set_State(player[i], HOLD_ATTACK);
					}
				}
            }
         if (Get_Press(KEY_TAB)) {
            if (player[0]->type == LENNY) {
               player[0]->type = BOAR;
               player[0]->palnum = 7;
               }
            else if (player[0]->type == BOAR) {
               player[0]->type = FLUFFY;
               player[0]->palnum = 14;
               }
            else if (player[0]->type == FLUFFY) {
               player[0]->type = RAT;
               player[0]->palnum = 0;
               }
            else if (player[0]->type == RAT) {
               player[0]->type = WEASEL;
               player[0]->palnum = 11;
               }
            else if (player[0]->type == WEASEL) {
               player[0]->type = ELK;
               player[0]->palnum = 11;
               }
			else if (player[0]->type == ELK) {
               player[0]->type = KOALA;
               player[0]->palnum = 19;
               }
            else {
                player[0]->type = LENNY;
                player[0]->palnum = 0;
                }
            }
         if (Get_Press(KEY_F)) {
            player[0]->hit_direction = 0;
            FA_Set_State(player[0], KNOCKED_DOWN);
            }
         if (Get_Press(KEY_C)) {
            if (!show_boxes)
               show_boxes = 1;
            else
                show_boxes = 0;
            }
         if (Get_Press(KEY_R)) {
         for (i=0;i<MAX_SPRITES;i++) {
						if (sprites[i].curr_state == INACTIVE) {
							if (key[KEY_ALT])
							Copy_Attributes(i,3);
							else if (key[KEY_LCONTROL] || key[KEY_RCONTROL])
							Copy_Attributes(i,2);
							else if (key[KEY_LSHIFT] || key[KEY_RSHIFT])
							Copy_Attributes(i,1);
							else
							Copy_Attributes(i,0);
							Place_Sprite((sprite_ptr)&sprites[i],(short)160+start_x,0,150);
                     sprites[i].curr_state = STANDING;
                     Find_Target((sprite_ptr)&sprites[i]);
                     if (log_mode) {
                        fprintf(logfile,"Enemy %s forced into slot %d.\n",sprites[i].name,i);
                        }
                     break;
							}
						}
         }
      if (Get_Press(KEY_B)) {
         for (i=0;i<MAX_SPRITES;i++) {
						if (sprites[i].curr_state == INACTIVE) {
							if (key[KEY_ALT])
							Copy_Attributes(i,7);
							else if (key[KEY_LCONTROL] || key[KEY_RCONTROL])
							Copy_Attributes(i,6);
							else if (key[KEY_LSHIFT] || key[KEY_RSHIFT])
							Copy_Attributes(i,5);
							else
							Copy_Attributes(i,4);
							Place_Sprite((sprite_ptr)&sprites[i],(short)160+start_x,0,150);
                     sprites[i].curr_state = STANDING;
                     Find_Target((sprite_ptr)&sprites[i]);
                     if (log_mode) {
                        fprintf(logfile,"Enemy %s forced into slot %d.\n",sprites[i].name,i);
                        }
                     break;
							}
						}
         }
      if (Get_Press(KEY_W)) {
         for (i=0;i<MAX_SPRITES;i++) {
						if (sprites[i].curr_state == INACTIVE) {
							if (key[KEY_ALT])
							Copy_Attributes(i,14);
							else if (key[KEY_LCONTROL] || key[KEY_RCONTROL])
							Copy_Attributes(i,13);
							else if (key[KEY_LSHIFT] || key[KEY_RSHIFT])
							Copy_Attributes(i,12);
							else
							Copy_Attributes(i,11);
							Place_Sprite((sprite_ptr)&sprites[i],(short)160+start_x,0,150);
                     sprites[i].curr_state = STANDING;
                     Find_Target((sprite_ptr)&sprites[i]);
                     if (log_mode) {
                        fprintf(logfile,"Enemy %s forced into slot %d.\n",sprites[i].name,i);
                        }
                     break;
							}
						}
         }
      if (Get_Press(KEY_E)) {
         for (i=0;i<MAX_SPRITES;i++) {
						if (sprites[i].curr_state == INACTIVE) {
                     if (key[KEY_LCONTROL] || key[KEY_RCONTROL])
							Copy_Attributes(i,17);
							else if (key[KEY_LSHIFT] || key[KEY_RSHIFT])
							Copy_Attributes(i,16);
							else
                     Copy_Attributes(i,15);
							Place_Sprite((sprite_ptr)&sprites[i],(short)160+start_x,0,150);
                     sprites[i].curr_state = STANDING;
                     Find_Target((sprite_ptr)&sprites[i]);
                     if (log_mode) {
                        fprintf(logfile,"Enemy %s forced into slot %d.\n",sprites[i].name,i);
                        }
                     break;
							}
						}
         }
	  if (Get_Press(KEY_Q)) {
         for (i=0;i<MAX_SPRITES;i++) {
						if (sprites[i].curr_state == INACTIVE) {
							if (key[KEY_ALT])
							Copy_Attributes(i,23);
							else if (key[KEY_LCONTROL] || key[KEY_RCONTROL])
							Copy_Attributes(i,22);
							else if (key[KEY_LSHIFT] || key[KEY_RSHIFT])
							Copy_Attributes(i,21);
							else
							Copy_Attributes(i,20);
							Place_Sprite((sprite_ptr)&sprites[i],(short)160+start_x,0,150);
                     sprites[i].curr_state = STANDING;
                     Find_Target((sprite_ptr)&sprites[i]);
                     if (log_mode) {
                        fprintf(logfile,"Enemy %s forced into slot %d.\n",sprites[i].name,i);
                        }
                     break;
							}
						}
         }
      if (Get_Press(KEY_F9)) {
         Write_PCX();
         }
	  if (Get_Press(KEY_F10)) {
		if (music_num < 8) {
			music_num++;
			}
		else {
			music_num = 0;
			}
		Play_Current_Music();
		}
      if (Get_Press(KEY_F1)) {
         for (i=0;i<MAX_SPRITES;i++) {
						if (sprites[i].curr_state == INACTIVE) {
                     if (key[KEY_LCONTROL] || key[KEY_RCONTROL])
							Copy_Attributes(i,10);
							else if (key[KEY_LSHIFT] || key[KEY_RSHIFT])
							Copy_Attributes(i,9);
							else
                     Copy_Attributes(i,8);
							Place_Sprite((sprite_ptr)&sprites[i],(short)160+start_x,0,150);
                     sprites[i].curr_state = STANDING;
                     Find_Target((sprite_ptr)&sprites[i]);
                     if (log_mode) {
                        fprintf(logfile,"Enemy %s forced into slot %d.\n",sprites[i].name,i);
                        }
                     break;
							}
						}
         }
	  if (Get_Press(KEY_F2)) {
         for (i=0;i<MAX_SPRITES;i++) {
						if (sprites[i].curr_state == INACTIVE) {
							if (key[KEY_LSHIFT] || key[KEY_RSHIFT])
							Copy_Attributes(i,19);
							else
                     Copy_Attributes(i,18);
							Place_Sprite((sprite_ptr)&sprites[i],(short)160+start_x,0,150);
                     sprites[i].curr_state = STANDING;
                     Find_Target((sprite_ptr)&sprites[i]);
                     if (log_mode) {
                        fprintf(logfile,"Enemy %s forced into slot %d.\n",sprites[i].name,i);
                        }
                     break;
							}
						}
         }
			
      if (Get_Press(KEY_K)) { // The Kill 'Em All Key!
         for (i=0;i<MAX_SPRITES;i++) {
            if (sprites[i].controlled_by == CPU_ENEMY && sprites[i].curr_state != DEAD) {
               FA_Set_State((sprite_ptr)&sprites[i], KNOCKED_DOWN);
               sprites[i].health = 0;
               sprites[i].hit_direction = (player[0]->x < sprites[i].x)? 1 : -1;
               }
            }
         } // end Kill 'Em All
         } 
		 }
         } // end handle controls loop? (Come back and double-check)
	for (i=0; i<MAX_SPRITES; i++) {
		sprites[i].x_vel_tracker += sprites[i].x_velocity;
		sprites[i].y_vel_tracker += sprites[i].y_velocity;
		sprites[i].z_vel_tracker += sprites[i].z_velocity;
		num_x_moves = sprites[i].x_vel_tracker / FPS;
		num_y_moves = sprites[i].y_vel_tracker / FPS;
		num_z_moves = sprites[i].z_vel_tracker / FPS;
		sprites[i].x_vel_tracker = (sprites[i].x_vel_tracker % FPS);
		sprites[i].y_vel_tracker = (sprites[i].y_vel_tracker % FPS);
		sprites[i].z_vel_tracker = (sprites[i].z_vel_tracker % FPS);
		if (num_x_moves < 0) {
		for (move_counter = 0; move_counter < -(num_x_moves); move_counter++)
          if (sprites[i].x > (left_end_offset+((left_end_slant == 0)? 0:((bottom_end_z-sprites[i].z)/left_end_slant))))
			    if (sprites[i].x > 0)
                sprites[i].x -= 1;
		} else {
		for (move_counter = 0; move_counter < num_x_moves; move_counter++)
          if (sprites[i].x < (((row_length * 16) - 1)+right_end_offset+((right_end_slant == 0)? 0:((bottom_end_z-sprites[i].z)/right_end_slant))))
			    if (sprites[i].x < (row_length * 16) - 1)
                sprites[i].x += 1;
		}
		if (num_y_moves < 0) {
		for (move_counter = 0; move_counter < -(num_y_moves); move_counter++)
			sprites[i].y -= 1;
		} else {
		for (move_counter = 0; move_counter < num_y_moves; move_counter++)
			if (sprites[i].y < 0)
				sprites[i].y += 1;
		}
		if (num_z_moves < 0) {
		for (move_counter = 0; move_counter < -(num_z_moves); move_counter++)
			if (sprites[i].z > top_end_z)
            if ((left_end_slant <= 0) || (sprites[i].z > (bottom_end_z-(((sprites[i].x-left_end_offset)+1)*left_end_slant))))
               if ((right_end_slant >= 0) || (sprites[i].z > (bottom_end_z+((((row_length*16)-sprites[i].x)+right_end_offset)*right_end_slant))))
				      sprites[i].z -= 1;
		} else {
		for (move_counter = 0; move_counter < num_z_moves; move_counter++)
			if (sprites[i].z < bottom_end_z)
				sprites[i].z += 1;
		}
		}
      if (start_x == trigger_points[next_trigger].xcoord) {
         if (log_mode && on_trigger != next_trigger) {
            fprintf(logfile,"start_x = %d, trigger point %d encountered.\n",start_x,next_trigger);
            fprintf(logfile,"on_trigger set equal to next_trigger.\n");
            }
		on_trigger = next_trigger;

         if (trigger_points[next_trigger].stop_scroll == 1) {
            if (log_mode && !scroll_lock) {
               fprintf(logfile,"Scroll locked.\n");
               }
				scroll_lock = 1;
            }
         }

      for (i=0; i<MAX_PLAYERS; i++) {
         if (player[i] != NULL) {
            if (player[i]->x < start_x)
               player[i]->x = start_x;
            if (player[i]->x > (start_x+SCREEN_WIDTH-1))
               player[i]->x = (start_x+SCREEN_WIDTH-1);
            }
         }
      num_x_moves = 0;
      for (i=0; i<MAX_PLAYERS; i++) {
         if (player[i] != NULL) {
            if ((player[i]->x - start_x) > (SCREEN_WIDTH/2))
               if (((player[i]->x - start_x)-(SCREEN_WIDTH/2)) > num_x_moves)
                  num_x_moves = ((player[i]->x - start_x)-(SCREEN_WIDTH/2));
            }
         }
	if (num_x_moves > 3)
        	num_x_moves = 3;
	if (num_x_moves > 0)
		if (!scroll_lock)
			for (move_counter = 0; move_counter<num_x_moves; move_counter++) {
				if (start_x < ((row_length * 16) - SCREEN_WIDTH))
					start_x++;
				if (start_x == trigger_points[next_trigger].xcoord) {
					on_trigger = next_trigger;
					if (log_mode) {
						fprintf(logfile,"start_x = %d, trigger point %d encountered.\n",start_x,next_trigger);
						fprintf(logfile,"on_trigger set equal to next_trigger.\n");
					}
					if (trigger_points[next_trigger].stop_scroll == 1) {
                        			if (log_mode && !scroll_lock) {
					                fprintf(logfile,"Scroll locked.\n");
						}
						scroll_lock = 1;
                        break;
					}
				}
                  	}
	if (on_trigger==-1 &&(next_trigger==100||trigger_points[next_trigger].xcoord==NO_TRIG)){
		scroll_lock = 0;
		next_trigger = 0;
		curr_enemy = 0;
		for (i=0; i<MAX_PLAYERS; i++)
			if (player[i] != NULL) {
				player[i]->flipflag = NOFLIP;
				player[i]->x_velocity = 0;
				player[i]->y_velocity = 0;
				player[i]->z_velocity = 0;
				player[i]->curr_state = STANDING;
			}
		start_x = 0;
		start_y = 0;
		curr_music++;
		if (curr_music > 2)
			curr_music = 0;
		if (strcmp(next_file_name,"END") == 0) {
		textprintf_centre(double_buffer,big_font,160,92,-1,"MISSION %d CLEAR",mission_number);
		vsync();
            	stretch_blit(double_buffer,screen,0,0,320,200,0,0,640,480);
            	for (i=0; i<210; i++)
                	vsync();
            	mission_number++;
            	if (mission_number > 8) {
               		mission_number = 1;
               	}
            	Load_Map(start_maps[mission_number-1]);
            	for (i=0; i<MAX_PLAYERS; i++) {
                	if (player[i] != NULL) {
                   		Place_Sprite(player[i], start_spot_x+(i*10), start_spot_y, start_spot_z+(i*10));
				player[i]->health = player[i]->max_health;
				player[i]->var2 = 0;
			}
                }
            if (log_mode) {
               fprintf(logfile,"End of stage.\n\n");
               fprintf(logfile,"Map %s loaded.\n",start_maps[mission_number-1]);
               }
            Play_Current_Music();
			show_status = 0;
			for (i=0; i<MAX_BARS; i++) {
				en_bar_time[i] = 0;
				}
			stand_by = 4;
            }
         else {
            if (log_mode) {
               fprintf(logfile,"Loading map %s.\n",next_file_name);
               }
            fade_out(1);
            Load_Map(next_file_name);
            for (i=0; i<MAX_PLAYERS; i++)
                if (player[i] != NULL) {
                   Place_Sprite(player[i], start_spot_x+(i*10), start_spot_y, start_spot_z+(i*10));
				   player[i]->var2 = 0;
					}
            Play_Current_Music();
			show_status = 0;
			for (i=0; i<MAX_BARS; i++) {
				en_bar_time[i] = 0;
				}
			stand_by = 3;
            }

         }
	if (on_trigger != -1) {
		while (curr_enemy < trigger_points[on_trigger].total_badguys && enemies_on_screen < trigger_points[on_trigger].max_at_once)
			if (trigger_points[on_trigger].badguy[curr_enemy].dif <= difficulty_level) {
				for (i=0;i<MAX_SPRITES;i++) {
					if (sprites[i].curr_state == INACTIVE) {
						Copy_Attributes(i,trigger_points[on_trigger].badguy[curr_enemy].who);
						Place_Sprite((sprite_ptr)&sprites[i],(short)(trigger_points[on_trigger].badguy[curr_enemy].where_x)+start_x,(short)trigger_points[on_trigger].badguy[curr_enemy].where_y,(short)trigger_points[on_trigger].badguy[curr_enemy].where_z);
						Find_Target((sprite_ptr)&sprites[i]);
						switch (trigger_points[on_trigger].badguy[curr_enemy].how) {
							case 0: // Yeah, what _about_ zero?
								sprites[i].curr_state = STANDING;
								break;
							case 1:
								sprites[i].curr_state = JUMPING;
								break;
							case 2:
								sprites[i].curr_state = CHARGING;
								break;
							case 3:
								sprites[i].curr_state =WALK_DOWN;
								break;
							case 4:
								sprites[i].curr_state = WALK_UP;
								break;
							case 5:
								sprites[i].curr_state = DOUBLE_JUMP;
								break;
							case 6:
								sprites[i].curr_state = DROP;
								break;
							case 7:
								sprites[i].curr_state = LEANING;
								break;
							case 8:
								sprites[i].curr_state = SITTING;
								break;
							case 9:
								sprites[i].curr_state = KNEELING_AWAY;
								break;
							case 10:
								sprites[i].curr_state = KNEELING_FORWARD;
								break;
							case 11:
								sprites[i].curr_state = KNEELING_TOWARD;
								break;
							case 12:
								sprites[i].curr_state = RIDE_CURTAINS;
								break;
							default:
								sprites[i].curr_state = STANDING;
								break;
							}
						curr_enemy++;
						enemies_on_screen++;
						if (log_mode) {
							fprintf(logfile,"Enemy %s introduced into slot %d in state %s, curr_enemy=%d.\n",sprites[i].name,i,state_names[sprites[i].curr_state],curr_enemy);
						}
						break;
					}
				}
			} else {
				curr_enemy++;
				if (log_mode) {
					fprintf(logfile,"Enemy skipped, curr_enemy=%d.\n",curr_enemy);
				}
			}
			if ((!scroll_lock) && (next_trigger == on_trigger)) {
				next_trigger++;
				curr_enemy = 0;
				if (log_mode) {
					fprintf(logfile,"next_trigger incremented to %d and curr_enemy reset to 0.\n",next_trigger);
				}
			}
			Count_Enemies();
			if (enemies_on_screen == 0 && curr_enemy == trigger_points[on_trigger].total_badguys) {
				curr_enemy = 0;
				if (scroll_lock) {
					next_trigger++;
					scroll_lock = 0;
					if (log_mode) {
						fprintf(logfile,"next_trigger incremented to %d and curr_enemy reset to 0.\n",next_trigger);
						fprintf(logfile,"Scroll lock released.\n");
					}
				}
				on_trigger = -1;
				if (log_mode) {
					fprintf(logfile,"on_trigger set to -1.\n");
				}
			}
		}
	if (start_x != trigger_points[next_trigger].xcoord) {
		Count_Enemies();
		if (enemies_on_screen == 0) {
			if (on_trigger != -1 && log_mode) {
				fprintf(logfile,"on_trigger set to -1.\n");
               		}
            	on_trigger = -1;
            	}
	}
	for (j=0; j<MAX_SPRITES; j++) {
       		if (sprites[j].curr_anim) {
			found_frame = 0;
			i = 0;
			frame_loc = 0;
         		while (!found_frame) {
				if ((anim_seqs[sprites[j].curr_anim][(i*2)+1] == 0) || (i == 8))
					if (anim_seqs[sprites[j].curr_anim][16] == 0) // Cycle?
						if (i) {
                        				sprites[j].frame_counter = 0;
                       					i = 0;
                        			} else {
                        				sprites[j].curr_frame=anim_seqs[sprites[j].curr_anim][0];
                        				found_frame = 1;
                        				break;
                        			}
                  else { // Once
                      sprites[j].anim_done = 1;
                      sprites[j].curr_frame=anim_seqs[sprites[j].curr_anim][(i*2)-2];
                      found_frame = 1;
                      break;
                      }
               frame_loc += anim_seqs[sprites[j].curr_anim][(i*2)+1];
               if (sprites[j].frame_counter < frame_loc) {
                  sprites[j].curr_frame=anim_seqs[sprites[j].curr_anim][i*2];
                  found_frame = 1;
                  break;
                  }
               i++;
               }
         if (!sprites[j].anim_done)
               sprites[j].frame_counter++;
         if (anim_seqs[sprites[j].curr_anim][16] == 1) {
            found_frame = 0;
            i = 0;
            frame_loc = 0;
            while (!found_frame) {
               if ((anim_seqs[sprites[j].curr_anim][(i*2)+1] == 0) || (i == 8)) { // End of anim. sequence?
                  found_frame = 1;
                  sprites[j].anim_done = 1;
                  }
               frame_loc += anim_seqs[sprites[j].curr_anim][(i*2)+1];
               if (sprites[j].frame_counter < frame_loc) {
                  found_frame = 1;
                  }
               i++;
               }
            }
         }
         }
	for (i=0; i<MAX_SPRITES; i++)
        	if (sprites[i].curr_anim) {
            		if (sprites[i].frame_counter == (anim_seqs[sprites[i].curr_anim][18] - 1)) {
               		sprites[i].curr_attack = anim_seqs[sprites[i].curr_anim][17];
               		} else if ((sprites[i].frame_counter > (anim_seqs[sprites[i].curr_anim][18] - 1)) && (attacks[sprites[i].curr_attack].is_continuous)) {
               			sprites[i].curr_attack = anim_seqs[sprites[i].curr_anim][17];
               		} else {
               			sprites[i].curr_attack = 0;
               		}
            	}
	for (j=0; j<MAX_PLAYERS; j++) {
        	if (player[j] != NULL && player[j]->curr_attack == -1){
			for (i=0;i<MAX_SPRITES;i++) {
                		if (sprites[i].controlled_by == CPU_ENEMY)
                   			if (sprites[i].curr_state != INACTIVE && sprites[i].curr_state != DEAD) {
	                      			FA_Set_State((sprite_ptr)&sprites[i], KNOCKED_DOWN);
                      				sprites[i].curr_attack = 0;
                      				sprites[i].hit_direction = (player[j]->x < sprites[i].x)? 1 : -1;
                      			}
                	}
            		player[j]->curr_attack = 0;
		}
	}
	for (i=0; i<MAX_SPRITES; i++) {
        	Handler((sprite_ptr)&sprites[i]);
		if (sprites[i].controlled_by == CPU_ENEMY) {
			for (j=0; j<MAX_PLAYERS; j++) {
				if ((player[j] != NULL) && (player[j]->curr_attack > 0)) {
					if (Check_For_Hit(player[j], (sprite_ptr)&sprites[i])) {
						score[j] += attacks[player[j]->curr_attack].point_value;
						en_bar_time[i] = EN_TIME;
						if (sprites[i].health == 0) {
							Score_Dead_Enemy((sprite_ptr)&sprites[i], j);
						}
					}
				}
			}
			 if (sprites[i].curr_state == THROWN || sprites[i].curr_state == HELD3) {
				 en_bar_time[i] = EN_TIME;
				if (sprites[i].var2 == 0) {
					score[Who_Did_It(sprites[i].hold)] += 500;
					sprites[i].var2 = 1;
					}
				for (j=0; j<MAX_SPRITES; j++) {
					if (sprites[j].controlled_by == CPU_ENEMY) {
						if (Thrown_Char_Hit((sprite_ptr)&sprites[i], (sprite_ptr)&sprites[j])) {
							en_bar_time[i] = EN_TIME;
							en_bar_time[j] = EN_TIME;
							score[Who_Did_It(sprites[i].hold)] += 250;
							if (sprites[j].health == 0) {
								Score_Dead_Enemy((sprite_ptr)&sprites[j], Who_Did_It(sprites[i].hold));
								}
							}
						}
					}
				if (sprites[i].y_velocity > 0 && sprites[i].y == 0) {
					FA_Set_State((sprite_ptr)&sprites[i], ON_GROUND_BRIEF);
					sprites[i].health -= sprites[i].var1;
					sprites[i].var1 = 0;
					sprites[i].var2 = 0;
					if (sprites[i].health <= 0) {
						sprites[i].health = 0;
						Death_Scream((sprite_ptr)&sprites[i]);
						Score_Dead_Enemy((sprite_ptr)&sprites[i], Who_Did_It(sprites[i].hold));
						}
					}
				}
			 for (j=0; j<MAX_PLAYERS; j++) {
				if ((player[j] != NULL) && (player[j]->curr_state == WALKING) && (sprites[i].y == 0) && !(sprites[i].invulnerable_flag)) {
					if ((player[j]->type == LENNY) || (player[j]->type == MING) || (player[j]->type == AL) || (player[j]->type == BOBO) /* || (player[j]->type == ELK) */) {
						if ((abs((int)player[j]->x - (int)sprites[i].x) <= PLAYER_GRAB_X_RANGE) && (abs((int)player[j]->z - (int)sprites[i].z) <= PLAYER_GRAB_Z_RANGE)) {
							if ((player[j]->h == ((sprites[i].x < player[j]->x)? -1 : 1)) || (player[j]->v == ((sprites[i].z < player[j]->z)? -1 : 1))) {
								FA_Set_State(player[j], HOLDING);
								player[j]->x_velocity = 0;
								player[j]->y_velocity = 0;
								player[j]->z_velocity = 0;
								player[j]->var1 = 0;
								player[j]->var2 = 0;
								player[j]->var3 = 0;
								player[j]->hold = (sprite_ptr)&sprites[i];
								if (sprites[i].hold != NULL) {
									FA_Set_State(sprites[i].hold, DROP_FREE);
									sprites[i].hold = NULL;
									}
								sprites[i].hold = player[j];
								FA_Set_State((sprite_ptr)&sprites[i], HELD1);
								en_bar_time[i] = EN_TIME;
								sprites[i].x_velocity = 0;
								sprites[i].y_velocity = 0;
								sprites[i].z_velocity = 0;
								sprites[i].var2 = 0;
								sprites[i].flipflag = ((player[j]->flipflag == FLIP)? NOFLIP : FLIP);
								}
							}
						}
					}
				}
         }
      if (sprites[i].controlled_by == HUMAN) {
         for (j=0; j<MAX_SPRITES; j++)
             if (sprites[j].controlled_by == CPU_ENEMY && sprites[j].curr_attack > 0)
                Check_For_Hit((sprite_ptr)&sprites[j], (sprite_ptr)&sprites[i]);
         }
         }
	for (j=0; j<MAX_SPRITES; j++) {
        	if (sprites[j].controlled_by == CPU_ENEMY) {
        		if (sprites[j].curr_state == GET_HIT_HEAD || sprites[j].curr_state == GET_HIT_STOMACH || sprites[j].curr_state == KNOCKED_DOWN || sprites[j].health <= 0) {
               			sprites[j].curr_attack = 0;
			}
            	}
	}
	for (j=0; j<MAX_PLAYERS; j++) {
		if (player[j] != NULL) {
         		if (player[j]->curr_state == GET_HIT_HEAD || player[j]->curr_state == GET_HIT_STOMACH || player[j]->curr_state == KNOCKED_DOWN || player[j]->health <= 0) {
            		player[j]->curr_attack = 0;
            		}
         		if (player[j]->curr_state==WAIT_FOR_NEXT_LIFE && player[j]->action_count == 1) {
            			lives[j]--;
	            	}
        	 	if (lives[j] <= 0) {
            			if (No_Other_Players(j)) {
               				if (continues[j] > 0) {
                  				continue_timer[j] = 1399;
                  				play_looped_midi(ns1_data[continue_song].dat, 1, -1);
	                  			while (continue_timer[j]) {
        	                			clear(double_buffer);
	        	                		textprintf_centre(double_buffer, big_font, 160, 68, -1, "CONTINUE? (Y/N)");
							textprintf_centre(double_buffer, big_font, 160, 92, -1, "%d", continue_timer[j]/70);
                	        			textprintf_centre(double_buffer, curr_font, 160, 116, -1, "CONTINUES = %d", continues[j]);
                        				vsync();
	                        			blit(double_buffer,screen,0,0,0,0,320,200);
        	                			continue_timer[j]--;
	        	                		if (Get_Press(KEY_Y)) {
        	        	           			score[j] = 0;
                	        	   			lives[j] = 3;
                        	   				continues[j]--;
	                           				Play_Current_Music();
        	                   				break;
	        	                   		}
        	        	        		if (Get_Press(KEY_N)) {
                	        	   			Game_Over();
                        	   				break;
	                           			}
        	                		}
                	 	 		if (!continue_timer[j]) {
	                	     			Game_Over();
        	             			}
	                  		} else	
						Game_Over();
               			}
			}	
		}
	}
	Set_Priflags();
	prisort(priority_table, 0, MAX_SPRITES-1);
	Draw_Screen(start_x,start_y);
	if (shadows_on)
		for (i=0; i<MAX_SPRITES; i++) {
			if (priority_table[i]->type != EFFECT) {
				Blit_Shadow(priority_table[i], shad);
			}
		}		
	for (i=0; i<MAX_SPRITES; i++) {
        	Palette_Blit_Sprite(priority_table[i]);
		if (show_boxes)
             		Draw_Collision_Box(priority_table[i]);
	}
	
	if (show_status) {
		Blit_Energy_Bar(player[0], 0, 184);
		textprintf(double_buffer, curr_font, 102, 184, -1, "x%d", lives[0]);
		textprintf(double_buffer, curr_font, 96, 192, -1, "%d", score[0]);
		if (players_in_game > 1) {
			Blit_Energy_Bar(player[1], 160, 184);
			textprintf(double_buffer, curr_font, 262, 184, -1, "x%d", lives[1]);
			textprintf(double_buffer, curr_font, 256, 192, -1, "%d", score[1]);
		}
		if (players_in_game > 2) {
			Blit_Energy_Bar(player[2], 0, 168);
			textprintf(double_buffer, curr_font, 102, 168, -1, "x%d", lives[2]);
			textprintf(double_buffer, curr_font, 96, 176, -1, "%d", score[2]);
		}
		if (players_in_game > 3) {
			Blit_Energy_Bar(player[3], 160, 168);
			textprintf(double_buffer, curr_font, 262, 168, -1, "x%d", lives[3]);
			textprintf(double_buffer, curr_font, 256, 176, -1, "%d", score[3]);
		}
	}
	  /*
	  textprintf(double_buffer, curr_font, 280, 160, -1, "%d", players_in_game);
	  textprintf(double_buffer, curr_font, 280, 168, -1, "%d", player[0]->var1);
      textprintf(double_buffer, curr_font, 280, 176, -1, "%d", player[0]->var3);
	  */	  
	  num_bars_drawn = 0;
		for (i=0; i<MAX_SPRITES; i++) {
			if (en_bar_time[i] && num_bars_drawn < 6) {
				Blit_Energy_Bar((sprite_ptr)&sprites[i], (num_bars_drawn/2)*109, (num_bars_drawn%2)*16);
				num_bars_drawn++;
				en_bar_time[i]--;
				}
			if (sprites[i].invulnerable_time) {
				sprites[i].invulnerable_time--;
				if (sprites[i].invulnerable_time == 0) {
					sprites[i].invulnerable_flag = 0;
					}
				}
			}
      if (Get_Press(KEY_P)) {
         paused = 1;
         textout_centre(double_buffer,big_font,"PAUSED",160,96,-1);
		 midi_pause();
         //vsync();
         blit(double_buffer,screen,0,0,0,0,320,200);
         do {
			 if (Get_Press(KEY_P)) {
               paused = 0;
				midi_resume();
			 }
            } while (paused);
         }
	  if (stand_by == 2) {
		  textprintf_centre(double_buffer,big_font,160,92,-1,"MISSION %d",mission_number);
          textout_centre(double_buffer,curr_font,stage_names[mission_number-1],160,116,-1);
          //vsync();
          stretch_blit(double_buffer,screen,0,0,320,200,0,0,640,480);
          for (i=0; i<210; i++)
			  vsync();
		  show_status = 1;
		  stand_by = 0;
		  }
		if (stand_by == 1) {
		  //vsync();
			stretch_blit(double_buffer,screen,0,0,320,200,0,0,640,480);
		  fade_in(ns1_data[ns1_pal].dat,1);
		  show_status = 1;
		  stand_by = 0;
		}
	if (stand_by < 3) {
		//vsync();
		stretch_blit(double_buffer,screen,0,0,320,200,0,0,640,480); // Main vsync/blit
	}
	  if (stand_by == 4)
		  stand_by = 2;
	  if (stand_by == 3)
		  stand_by = 1;
      }
	 if (logfile != NULL) {
		fclose(logfile);
	  }
	}
END_OF_MAIN();
