#include "handler.h"
#include "nsdefs.h"
#include "ns1dat.h"
#include "sprite8.h"
#include "lenny.h"
#include "boar.h"
#include "fluffy.h"
#include "rat.h"
#include "weasel.h"
#include "elk.h"
#include "rhino.h"
#include "koala.h"

#include "scrollnu.h"

#include "allegro.h"

void Death_Scream(sprite_ptr spr) {
	switch (spr->type) {
		case WEASEL:
			play_sample(ns1_data[weasel_die_snd].dat, 255, 128, 1000, FALSE);
            break;
        default:
            play_sample(ns1_data[rat_die_snd].dat, 255, 128, 1000, FALSE);
            break;
            }
        }

void Handler(sprite_ptr spr) {
   int i;
   if (spr->type == LENNY) {
      Handle_Lenny(spr);
      }
   if (spr->type == BOAR) {
      if (spr->controlled_by == CPU_ENEMY)
         Do_Boar_AI(spr);
      Handle_Boar(spr);
      }
   if (spr->type == FLUFFY) {
      if (spr->controlled_by == CPU_ENEMY)
         Do_Fluffy_AI(spr);
      Handle_Fluffy(spr);
      }
   if (spr->type == RAT) {
      if (spr->controlled_by == CPU_ENEMY)
         Do_Rat_AI(spr);
      Handle_Rat(spr);
      }
   if (spr->type == WEASEL) {
      if (spr->controlled_by == CPU_ENEMY)
         Do_Weasel_AI(spr);
      Handle_Weasel(spr);
      }
   if (spr->type == ELK) {
	   if (spr->controlled_by == CPU_ENEMY)
		   Do_Elk_AI(spr);
      Handle_Elk(spr);
      }
   if (spr->type == RHINO) {
		Handle_Rhino(spr);
		}
   if (spr->type == KOALA) {
	   if (spr->controlled_by == CPU_ENEMY)
		   Do_Koala_AI(spr);
	   Handle_Koala(spr);
		}
   if (spr->type == EFFECT) {
	   if (spr->var1 == BLOOD) {
			spr->x_velocity = 0;
			spr->y_velocity = 0;
			spr->z_velocity = 0;
			spr->curr_anim = 40;
			}
		if (spr->anim_done) {
			FA_Set_State(spr, INACTIVE);
			spr->curr_frame = -1;
			spr->type = NO_TYPE;
			spr->controlled_by = CPU;
			spr->x = NOWHERE;
			spr->y = NOWHERE;
			}
		}
   if (spr->curr_state == STANDING) {
      spr->curr_anim = 0;
      spr->curr_attack = 0;
	  if (!spr->invulnerable_time) {
		spr->invulnerable_flag = 0;
		}
      spr->hit_direction = 0;
      spr->x_velocity = 0;
      spr->y_velocity = 0;
      spr->z_velocity = 0;
      spr->h = 0;
      spr->v = 0;
      if (spr->controlled_by == HUMAN && spr->target) {
         spr->target = 0;
            if (spr->var1 < 4)
               spr->var1++;
            else
                spr->var1 = 0;
         }
      }
   if (spr->curr_state == HELD1) {
		spr->x_velocity = 0;
		spr->y_velocity = 0;
		spr->z_velocity = 0;
		spr->curr_anim = 0;
		spr->curr_attack = 0;
		if (spr->hold == NULL) {
			FA_Set_State(spr, DROP_FREE);
			}
		else if (spr->hold->hold == NULL) {
			spr->hold = NULL;
			FA_Set_State(spr, DROP_FREE);
			}
		}
   if (spr->curr_state == HELD2) {
		spr->x_velocity = 0;
		spr->y_velocity = 0;
		spr->z_velocity = 0;
		spr->curr_anim = 0;
		spr->curr_attack = 0;
		if (spr->hold == NULL) {
			FA_Set_State(spr, DROP_FREE);
			}
		else if (spr->hold->hold == NULL) {
			spr->hold = NULL;
			FA_Set_State(spr, DROP_FREE);
			}
		}
   if (spr->curr_state == DROP_FREE) {
	   spr->hold = NULL;
	   spr->y_velocity = (spr->action_count * GRAVITY);
	   spr->action_count++;
	   if (spr->y == 0) {
		   FA_Set_State(spr, STANDING);
			}
		}
   if (spr->curr_state == GET_HIT_STOMACH || spr->curr_state == GET_HIT_HEAD) {
      if (spr->y < 0)
         FA_Set_State(spr, KNOCKED_DOWN);
      else {
         spr->x_velocity = 0;
         spr->y_velocity = 0;
         spr->z_velocity = 0;
         if (spr->action_count < 5)
            spr->x += (1 * spr->hit_direction);
         if (spr->action_count >= 5 && spr->action_count < 10)
            spr->x -= (1 * spr->hit_direction);
         if (spr->controlled_by == HUMAN)
            if (spr->action_count == 30) {
               FA_Set_State(spr, STANDING);
               spr->hit_direction = 0;
               }
         spr->action_count++;
         }
      }
   if (spr->curr_state == THROWN) {
		spr->y_velocity += GRAVITY;
		}
   if (spr->curr_state == KNOCKED_DOWN) {
         spr->invulnerable_flag = 1;
         spr->y_velocity = (-30 + spr->action_count) * GRAVITY;
			spr->x_velocity = E_FALL_VEL * spr->hit_direction;
			spr->z_velocity = 0;
			if (spr->health <= 0 && spr->action_count == 0) {
				Death_Scream(spr);
				}
			spr->action_count++;
			if (spr->y_velocity > 0 && spr->y == 0) {
				FA_Set_State(spr, ON_GROUND_BRIEF);
            }
			}
		if (spr->curr_state == ON_GROUND_BRIEF) {
			spr->x_velocity = 0;
			spr->y_velocity = 0;
			spr->z_velocity = 0;
         if (spr->action_count == 0) {
            play_sample(ns1_data[hit_ground_snd].dat, 255, 128, 1000, FALSE);
            }
			if (spr->action_count == 5) {
            FA_Set_State(spr, BOUNCE);
            }
			spr->action_count++;
			}
		if (spr->curr_state == BOUNCE) {
         spr->y_velocity = (-10 + spr->action_count) * GRAVITY;
			spr->z_velocity = 0;
			spr->x_velocity = E_FALL_VEL * spr->hit_direction;
			spr->action_count++;
			if (spr->y_velocity > 0 && spr->y == 0) {
            FA_Set_State(spr, ON_GROUND);
            }
			}
		if (spr->curr_state == ON_GROUND) {
			spr->x_velocity = 0;
			spr->y_velocity = 0;
			spr->z_velocity = 0;
			spr->var2 = 0;
         if (spr->action_count == 0) {
            play_sample(ns1_data[hit_ground_snd].dat, 255, 128, 1000, FALSE);
            }
			if (spr->health < 1) {
            FA_Set_State(spr, DEAD);
            }
         }
      if (spr->curr_state == DEAD) {
         if (spr->action_count == 42)
            FA_Set_State(spr, BLINK_OUT);
         else
             spr->action_count++;
         }
      if (spr->curr_state == BLINK_OUT) {
         if (spr->action_count % 12 == 0)
            spr->y += NOWHERE; // disappears
         if (spr->action_count % 12 == 6)
            spr->y -= NOWHERE; // reappears
         if (spr->action_count == 36) {
            if (spr->controlled_by == CPU_ENEMY) {
               FA_Set_State(spr, INACTIVE);
               spr->type = NO_TYPE;
               spr->controlled_by = CPU;
               }
            else if (spr->controlled_by == HUMAN) {
               FA_Set_State(spr, WAIT_FOR_NEXT_LIFE);
               }
            spr->hit_direction = 0;
			spr->curr_frame = -1;
            }
         else
             spr->action_count++;
         }
      if (spr->curr_state == WAIT_FOR_NEXT_LIFE) {
         if (spr->action_count == 0)
            Place_Sprite(spr, (short)start_x+24, -200, 164);
         spr->flipflag = NOFLIP;
         spr->health = spr->max_health;
         spr->x_velocity = 0;
         spr->z_velocity = 0;
         if (spr->action_count > 40)
            spr->y_velocity = ((spr->action_count-40) * GRAVITY);
         else
            spr->y_velocity = 0;
         if (spr->y == 0) { // Knock enemies down as player re-enters
            FA_Set_State(spr, STANDING);
            spr->curr_attack = -1;
            spr->invulnerable_time = 210;
            }
         spr->action_count++;
         }
      if (spr->stun > 0)
         spr->stun--;
      if (spr->invulnerable_time > 0) {
         spr->invulnerable_time--;
         if (spr->invulnerable_time == 0)
            spr->invulnerable_flag = 0;
         }
      if (spr->controlled_by == HUMAN) {
         if (spr->var3)
            spr->var3--;
         else if (spr->curr_state == STANDING || spr->curr_state == WALKING || spr->curr_state == JUMPING) {
            spr->var1 = 0;
			}
         }
   }

