#include "config.h"

#include "allegro.h"

#include <string.h>

#define FROM_SOUND_C
#include "sound.h"
#undef FROM_SOUND_C

#include "globvars.h"

#include "math.h"
#include "stuff.h"

enum
{
DIRECT_WAV,
DIRECT_BEAT
};

// # is octave

#define L_0 64
#define L_1 32
#define L_2 16
#define L_3 11
#define L_4 8
#define L_6 6
#define L_8 4
#define L_16 2

#define XL_0 48
#define XL_1 24
#define XL_2 12
#define XL_3 8
#define XL_4 6
#define XL_6 4
#define XL_8 3
#define XL_16 2

#define PAN_L 64
#define PAN_C 127
#define PAN_R 192



#define BASE_TONE 200
int tone [NO_TONES];


enum
{
    SOUNDMODE_STEREO,
    SOUNDMODE_MONO,
    SOUNDMODE_REVERSED
};

enum
{
BEAT_NONE,
BEAT_SILENT,
BEAT_BASIC,
BEAT_LINE1,
BEAT_LINE2,
BEAT_DRUM1,
BEAT_DRUM2,
BEAT_DRUM3,
BEAT_DRUM4,
BEAT_CYMBAL1,
BEAT_SLINE,
BEAT_NICE,
BEAT_LONG,
BEAT_LONG2,
BEAT_SWEET,
BEAT_XLINE,
BEAT_XLINE2,
BEAT_XLINE3,
BEAT_FLUTE2_S,
BEAT_FLUTE2_L,
BEAT_FLUTE,
BEAT_FLUTE_L,
BEAT_GLURR,
BEAT_DLINE2,
BEAT_SYNTH,
BEAT_STAGE4,
BEAT_MULTI,
NO_BEATS,
BEAT_END

};


// when on the next tick we're going to play a note with an attached event, set this to something
//  for the relevant event so that if the event is ready it can be done
int synch_ready [NO_EVENTS];
// when we've done something, set this to the note that we want to play.
int synch_done [NO_DONE];
// both externed in sound.h

enum // keep these in proper order!
{
 SUBMUSIC_EMPTY,
 SUBMUSIC_L1_BASIC,
 SUBMUSIC_L1_BEAT,
 SUBMUSIC_L1_FIRE,
 SUBMUSIC_L1_BASIC2,
 SUBMUSIC_L1_BASIC3,
 SUBMUSIC_L1_FIRE2,

 SUBMUSIC_L2_BEAT,
 SUBMUSIC_L2_BEAT_INCOMPLETE,
 SUBMUSIC_L2_BASIC,
 SUBMUSIC_L2_BASIC2,
 SUBMUSIC_L2_BASIC3,
 SUBMUSIC_L2_BASIC4,
 SUBMUSIC_L2_SONG,
 SUBMUSIC_L2_SONG2,

 SUBMUSIC_L3_SWEET,
 SUBMUSIC_L3_SWEET2,
 SUBMUSIC_L3_BEAT,
 SUBMUSIC_L3_BEAT2,
 SUBMUSIC_L3_XLINE,
 SUBMUSIC_L3_XLINE2,
 SUBMUSIC_L3_XLINE3,

 SUBMUSIC_L4_BASE1,
 SUBMUSIC_L4_BASE2,
 SUBMUSIC_L4_BASE3,

 SUBMUSIC_L4_UPDOWN1,
 SUBMUSIC_L4_UPDOWN2,
 SUBMUSIC_L4_UPDOWN3,

 SUBMUSIC_L4_CLIMB1,
 SUBMUSIC_L4_CLIMB2,

 SUBMUSIC_END,
 NO_SUBMUSICS
};

#define NO_MUSICS 12

int music [NO_OVERMUSICS] [NO_MUSICS] [NO_SUBMUSICS] =
{
 {
  {SUBMUSIC_L1_BEAT, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
  {SUBMUSIC_END, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 },
 {
  {SUBMUSIC_L1_BEAT, SUBMUSIC_L1_BASIC, SUBMUSIC_L1_FIRE},
  {SUBMUSIC_L1_BEAT, SUBMUSIC_L1_BASIC, SUBMUSIC_L1_FIRE2},
  {SUBMUSIC_L1_BEAT, SUBMUSIC_L1_BASIC2, SUBMUSIC_L1_FIRE},
  {SUBMUSIC_L1_BEAT, SUBMUSIC_L1_BASIC, SUBMUSIC_L1_FIRE2},
  {SUBMUSIC_L1_BEAT, SUBMUSIC_L1_BASIC3, SUBMUSIC_L1_FIRE},
  {SUBMUSIC_END, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 },
 {
  {SUBMUSIC_L2_BEAT_INCOMPLETE, SUBMUSIC_L2_BASIC, SUBMUSIC_EMPTY},
  {SUBMUSIC_END, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 },
 {
  {SUBMUSIC_L2_BEAT, SUBMUSIC_L2_BASIC, SUBMUSIC_EMPTY},
  {SUBMUSIC_END, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 },
 {
  {SUBMUSIC_L2_BEAT, SUBMUSIC_L2_BASIC, SUBMUSIC_L2_SONG},
  {SUBMUSIC_L2_BEAT, SUBMUSIC_L2_BASIC2, SUBMUSIC_L2_SONG2},
  {SUBMUSIC_L2_BEAT, SUBMUSIC_L2_BASIC3, SUBMUSIC_L2_SONG2},
  {SUBMUSIC_L2_BEAT, SUBMUSIC_L2_BASIC4, SUBMUSIC_L2_SONG2},
  {SUBMUSIC_END, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 },
 {
  {SUBMUSIC_L3_BEAT, SUBMUSIC_L3_SWEET, SUBMUSIC_EMPTY},
  {SUBMUSIC_END, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 },

 {
  {SUBMUSIC_L3_BEAT, SUBMUSIC_L3_SWEET, SUBMUSIC_L3_XLINE},
  {SUBMUSIC_END, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 },

 {
  {SUBMUSIC_L3_BEAT2, SUBMUSIC_L3_SWEET, SUBMUSIC_L3_XLINE},
  {SUBMUSIC_L3_BEAT2, SUBMUSIC_L3_SWEET, SUBMUSIC_L3_XLINE2},
  {SUBMUSIC_L3_BEAT2, SUBMUSIC_L3_SWEET, SUBMUSIC_L3_XLINE},
  {SUBMUSIC_L3_BEAT2, SUBMUSIC_L3_SWEET, SUBMUSIC_L3_XLINE},
  {SUBMUSIC_END, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 },

 {
  {SUBMUSIC_L3_BEAT2, SUBMUSIC_L3_SWEET, SUBMUSIC_L3_XLINE},
  {SUBMUSIC_L3_BEAT2, SUBMUSIC_L3_SWEET2, SUBMUSIC_L3_XLINE2},
  {SUBMUSIC_L3_BEAT2, SUBMUSIC_L3_SWEET, SUBMUSIC_L3_XLINE},
  {SUBMUSIC_L3_BEAT2, SUBMUSIC_L3_SWEET2, SUBMUSIC_L3_XLINE},
  {SUBMUSIC_L3_BEAT2, SUBMUSIC_L3_SWEET, SUBMUSIC_L3_XLINE2},
  {SUBMUSIC_L3_BEAT2, SUBMUSIC_L3_SWEET2, SUBMUSIC_L3_XLINE3},
  {SUBMUSIC_END, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 },

 {
  {SUBMUSIC_L4_BASE1, SUBMUSIC_L4_CLIMB1, SUBMUSIC_EMPTY},
  {SUBMUSIC_L4_BASE1, SUBMUSIC_L4_CLIMB1, SUBMUSIC_EMPTY},
  {SUBMUSIC_L4_BASE2, SUBMUSIC_L4_CLIMB1, SUBMUSIC_EMPTY},
  {SUBMUSIC_L4_BASE3, SUBMUSIC_L4_CLIMB1, SUBMUSIC_EMPTY},
  {SUBMUSIC_END, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 },

 {
  {SUBMUSIC_L4_UPDOWN1, SUBMUSIC_L4_CLIMB1, SUBMUSIC_EMPTY},
  {SUBMUSIC_L4_UPDOWN1, SUBMUSIC_L4_CLIMB1, SUBMUSIC_EMPTY},
  {SUBMUSIC_L4_UPDOWN2, SUBMUSIC_L4_CLIMB1, SUBMUSIC_EMPTY},
  {SUBMUSIC_L4_UPDOWN3, SUBMUSIC_L4_CLIMB1, SUBMUSIC_EMPTY},
  {SUBMUSIC_END, SUBMUSIC_EMPTY, SUBMUSIC_EMPTY},
 }

};



#define VOL_L 100
#define VOL_M 200
#define VOL_H 255

SAMPLE *sounds [NO_WAVS];

SAMPLE *beat [NO_BEATS];

enum
{
SM_BEAT,
SM_TONE,
SM_LENGTH,
SM_VOL,
SM_PAN,
SM_EVENT1,
SM_EVENT2,
SM_EVENT3,
SM_ALT_TONE,
SM_SIZE
};

int submusic [NO_SUBMUSICS] [51] [SM_SIZE] =
{
 {
  {BEAT_END, L_1,0,0},
 },
 {
//{BEAT_SILENT, NOTE_2C, 5, VOL_H, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},

  {BEAT_LINE2, NOTE_1C, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE1, NOTE_2C, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_1G, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE1, NOTE_1AS, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE1, NOTE_1F, L_8, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE1, NOTE_1G, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE1, NOTE_1DS, L_8, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_1E, L_16, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },
 {
//  {BEAT_SILENT, NOTE_2C, 5, VOL_H, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},

/*  {BEAT_DRUM3, NOTE_0G, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM3, NOTE_0G, 7, VOL_M, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM3, NOTE_1C, 9, VOL_H, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},*/
  {BEAT_DRUM3, NOTE_1G, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_CYMBAL1, NOTE_1G, 7, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM3, NOTE_2C, 9, VOL_H, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_CYMBAL1, NOTE_0D, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM4, NOTE_1C, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_CYMBAL1, NOTE_1G, L_2 - 1, VOL_H, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},

/*  {BEAT_DRUM3, NOTE_0G, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_CYMBAL1, NOTE_1G, 7, VOL_M, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM3, NOTE_1C, 9, VOL_H, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_CYMBAL1, NOTE_0D, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM4, NOTE_1C, L_1, VOL_H, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},*/

/*
  {BEAT_DRUM3, NOTE_1C, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_CYMBAL1, NOTE_1C, L_4, VOL_M, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM3, NOTE_0G, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_CYMBAL1, NOTE_0G, L_4, VOL_M, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_CYMBAL1, NOTE_1F, L_4, VOL_M, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM4, NOTE_1C, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},*/

/*

  {BEAT_SILENT, NOTE_2C, 5, VOL_H, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_CYMBAL1, NOTE_2C, L_4, VOL_L, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM3, NOTE_2C, L_4, VOL_M, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM4, NOTE_1G, L_4, VOL_M, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_CYMBAL1, NOTE_2C, L_4, VOL_L, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM3, NOTE_2C, L_4, VOL_M, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM4, NOTE_1G, L_4, VOL_M, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_CYMBAL1, NOTE_2C, L_4, VOL_L, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},*/
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },
 {
//  {BEAT_SILENT, NOTE_2C, L_16, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},

  {BEAT_SLINE, NOTE_2C, L_2, VOL_M, PAN_C, EVENT_SWOOPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_SLINE, NOTE_3C, L_4, VOL_M, PAN_C, EVENT_SWOOPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_SLINE, NOTE_2G, 1, VOL_M, PAN_C, EVENT_SWOOPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_1G},
  {BEAT_NICE, NOTE_2E, L_2 - 1, VOL_M, PAN_C, EVENT_STOPPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_1AS},
  {BEAT_SLINE, NOTE_2AS, L_4, VOL_M, PAN_C, EVENT_SWOOPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_2AS},
  {BEAT_SLINE, NOTE_2F, L_8, VOL_M, PAN_C, EVENT_SWOOPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_2D},
  {BEAT_SLINE, NOTE_2G, L_4, VOL_H, PAN_C, EVENT_SWOOPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_SLINE, NOTE_2AS, L_8, VOL_M, PAN_C, EVENT_SWOOPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_2F},
  {BEAT_SLINE, NOTE_2F, 1, VOL_M, PAN_C, EVENT_SWOOPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_2AS},
  {BEAT_NICE, NOTE_2F, L_16 - 1, VOL_M, PAN_C, EVENT_STOPPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_2F},
//  {BEAT_NICE, NOTE_2E, 1, VOL_M, PAN_C, EVENT_STOPPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_2AS},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_LINE2, NOTE_2C, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE1, NOTE_1G, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_1AS, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE1, NOTE_1G, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE1, NOTE_2C, L_8, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE1, NOTE_1AS, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE1, NOTE_1F, L_8, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_1E, L_16, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_LINE2, NOTE_1C, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE1, NOTE_1G, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_2C, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE1, NOTE_2DS, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE1, NOTE_2C, L_8, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE1, NOTE_2F, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE1, NOTE_2DS, L_8, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_2E, L_16, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },
 {
//  {BEAT_SILENT, NOTE_2C, L_16, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},

  {BEAT_SLINE, NOTE_2C, L_2, VOL_M, PAN_C, EVENT_SWOOPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SLINE, NOTE_2G, L_4, VOL_M, PAN_C, EVENT_SWOOPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_2G},
  {BEAT_SLINE, NOTE_3C, 1, VOL_M, PAN_C, EVENT_SWOOPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_NICE, NOTE_2DS, L_2 - 1, VOL_M, PAN_C, EVENT_STOPPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_2DS},
  {BEAT_SLINE, NOTE_3DS, L_4, VOL_M, PAN_C, EVENT_SWOOPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_2G},
  {BEAT_SLINE, NOTE_3C, L_8, VOL_M, PAN_C, EVENT_SWOOPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SLINE, NOTE_3F, L_4, VOL_H, PAN_C, EVENT_SWOOPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_2G},
  {BEAT_SLINE, NOTE_2G, L_8, VOL_M, PAN_C, EVENT_SWOOPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_3F},
  {BEAT_SLINE, NOTE_3C, 1, VOL_M, PAN_C, EVENT_SWOOPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_NICE, NOTE_2C, L_16 - 1, VOL_M, PAN_C, EVENT_STOPPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_2C},
// changed some lengths here
//  {BEAT_NICE, NOTE_2E, 1, VOL_M, PAN_C, EVENT_STOPPER1_FIRE, EVENT_NONE, EVENT_NONE, NOTE_2AS},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },


 {
  {BEAT_DRUM3, NOTE_1G, XL_1, VOL_H, PAN_C, EVENT_PULSE1, EVENT_PULSE, EVENT_NONE},
//  {BEAT_DRUM3, NOTE_1G, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM4, NOTE_1G, XL_2, VOL_H, PAN_C, EVENT_PULSE2, EVENT_PULSE, EVENT_NONE},
  {BEAT_DRUM3, NOTE_1G, XL_2, VOL_M, PAN_C, EVENT_PULSE1, EVENT_PULSE, EVENT_NONE},
//  {BEAT_DRUM3, NOTE_1G, L_4, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM4, NOTE_1G, XL_1 + XL_2, VOL_M, PAN_C, EVENT_PULSE2, EVENT_PULSE, EVENT_NONE},
//  {BEAT_DRUM3, NOTE_1G, L_2, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM3, NOTE_1G, XL_2, VOL_M, PAN_C, EVENT_PULSE1, EVENT_PULSE, EVENT_NONE},
//  {BEAT_DRUM3, NOTE_1G, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },
/*
 {
  {BEAT_SILENT, NOTE_1G, L_1, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM4, NOTE_1G, L_2, VOL_H, PAN_C, EVENT_PULSE1, EVENT_NONE, EVENT_NONE},
  {BEAT_SILENT, NOTE_1G, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM4, NOTE_1G, L_1 + L_2, VOL_M, PAN_C, EVENT_PULSE1, EVENT_NONE, EVENT_NONE},
  {BEAT_SILENT, NOTE_1G, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_LONG2, NOTE_1F, L_1, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_LONG, NOTE_2C, L_16, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
//  {BEAT_LONG, NOTE_2C, L_16, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_LONG2, NOTE_2C, L_1, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_LONG, NOTE_1G, L_16, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_LONG2, NOTE_1G, L_1, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_LONG, NOTE_2DS, L_16, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_LONG2, NOTE_2DS, L_1, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_LONG, NOTE_1F, L_16, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },


 {
  {BEAT_SILENT, NOTE_2C, L_1, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_2C, L_2, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_3C, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_2B, L_2, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_2C, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_3E, L_4, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_2B, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_3C, L_2, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_2B, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_2E, L_3, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_SILENT, NOTE_2C, L_6, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_2B, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_2E, L_3, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_SILENT, NOTE_2C, L_1 - L_6 - L_4 - L_3, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_2C, L_2, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_3C, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_2B, L_2, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_2C, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_3E, L_4, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_2B, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_3C, L_2, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_2B, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_LINE2, NOTE_2E, L_3, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_SWEET, NOTE_2C, L_2, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SWEET, NOTE_2FS, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SWEET, NOTE_2B, L_1, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SWEET, NOTE_2C, L_2, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SWEET, NOTE_2B, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SWEET, NOTE_2FS, L_1, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_DRUM4, NOTE_1G, L_2 + L_2 + L_1, VOL_H, PAN_C, EVENT_PULSE1, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_DRUM4, NOTE_1C, L_2 + L_2 + L_1, VOL_H, PAN_C, EVENT_PULSE2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_DRUM4, NOTE_1G, L_1, VOL_H, PAN_C, EVENT_PULSE1, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_CYMBAL1, NOTE_1C, L_2, VOL_H, PAN_C, EVENT_PULSE2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_CYMBAL1, NOTE_1C, L_2, VOL_H, PAN_C, EVENT_PULSE2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_DRUM4, NOTE_1C, L_1, VOL_H, PAN_C, EVENT_PULSE2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_CYMBAL1, NOTE_1C, L_2, VOL_H, PAN_C, EVENT_PULSE1, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_CYMBAL1, NOTE_1C, L_2, VOL_H, PAN_C, EVENT_PULSE1, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },
*/

 {
  {BEAT_SILENT, NOTE_1G, XL_1, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM4, NOTE_1G, XL_2, VOL_M, PAN_C, EVENT_PULSE1, EVENT_NONE, EVENT_NONE},
  {BEAT_SILENT, NOTE_1G, XL_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM4, NOTE_1G, XL_1 + XL_2, VOL_M, PAN_C, EVENT_PULSE1, EVENT_NONE, EVENT_NONE},
  {BEAT_SILENT, NOTE_1G, XL_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },
 {
  {BEAT_LONG2, NOTE_1F, XL_1, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_LONG, NOTE_2C, XL_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_1C, XL_1, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_1C, XL_1, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_1C, XL_2, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
//  {BEAT_LONG, NOTE_2C, XL_16, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_LONG2, NOTE_2C, XL_1, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_LONG, NOTE_1G, XL_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_1G, XL_1, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_1G, XL_1, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_1G, XL_2, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_LONG2, NOTE_1G, XL_1, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_LONG, NOTE_2DS, XL_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_1DS, XL_1, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_1DS, XL_1, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_1DS, XL_2, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_LONG2, NOTE_2DS, XL_1, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_LONG, NOTE_1F, XL_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_1F, XL_1, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_1F, XL_1, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_1F, XL_2, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },
/*
 {
  {BEAT_LONG2, NOTE_1F, XL_1, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_LONG, NOTE_2C, XL_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_2G, XL_2, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_1G, XL_2, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_2C, XL_2, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
//  {BEAT_LONG, NOTE_2C, XL_16, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_LONG2, NOTE_2C, XL_1, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_LONG, NOTE_1G, XL_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_1C, XL_2, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_1G, XL_2, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_2C, XL_2, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_LONG2, NOTE_1G, XL_1, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_LONG, NOTE_2DS, XL_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_1DS, XL_2, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_1AS, XL_2, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_2DS, XL_2, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_LONG2, NOTE_2DS, XL_1, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_LONG, NOTE_1F, XL_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_1C, XL_2, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_1F, XL_2, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SYNTH, NOTE_2C, XL_2, VOL_M, PAN_C, EVENT_FIRE2_2, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },
*/
 {
  {BEAT_SILENT, NOTE_2C, XL_1 - XL_16, VOL_H, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE},
  {BEAT_DLINE2, NOTE_2C, XL_2, VOL_H, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_2B},
  {BEAT_DLINE2, NOTE_3C, XL_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_2E},
  {BEAT_DLINE2, NOTE_2B, XL_2, VOL_H, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_3E},
  {BEAT_DLINE2, NOTE_2C, XL_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_DLINE2, NOTE_3E, XL_4, VOL_H, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_3E},
  {BEAT_DLINE2, NOTE_2B, XL_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_2B},
  {BEAT_DLINE2, NOTE_3C, XL_2, VOL_H, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_DLINE2, NOTE_2B, XL_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3E},
  {BEAT_DLINE2, NOTE_2E, XL_3, VOL_M, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_SILENT, NOTE_2C, XL_8, VOL_H, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_3E},
  {BEAT_DLINE2, NOTE_2B, XL_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3E},
  {BEAT_DLINE2, NOTE_2E, XL_3, VOL_M, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_SILENT, NOTE_2C, XL_1 - XL_8 - XL_4 - XL_3 - XL_16, VOL_H, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE},
  {BEAT_DLINE2, NOTE_2C, XL_2, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_2B},
  {BEAT_DLINE2, NOTE_3C, XL_2, VOL_M, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_2E},
  {BEAT_DLINE2, NOTE_2B, XL_2, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3E},
  {BEAT_DLINE2, NOTE_2C, XL_2, VOL_M, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_DLINE2, NOTE_3E, XL_4, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3E},
  {BEAT_DLINE2, NOTE_2B, XL_2, VOL_M, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_2B},
  {BEAT_DLINE2, NOTE_3C, XL_2, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_DLINE2, NOTE_2B, XL_4, VOL_M, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_3E},
  {BEAT_DLINE2, NOTE_2E, XL_3, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },


/*
 {
  {BEAT_SILENT, NOTE_2C, XL_1 - XL_16, VOL_H, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE},
  {BEAT_DLINE2, NOTE_2C, XL_2, VOL_H, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_2B},
  {BEAT_DLINE2, NOTE_3C, XL_2, VOL_M, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_2E},
  {BEAT_DLINE2, NOTE_2B, XL_2, VOL_H, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_3E},
  {BEAT_DLINE2, NOTE_2C, XL_2, VOL_M, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_DLINE2, NOTE_3E, XL_4, VOL_H, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_3E},
  {BEAT_DLINE2, NOTE_2B, XL_2, VOL_M, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_2B},
  {BEAT_DLINE2, NOTE_3C, XL_2, VOL_H, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_DLINE2, NOTE_2B, XL_4, VOL_M, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_3E},
  {BEAT_DLINE2, NOTE_2E, XL_3, VOL_M, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_SILENT, NOTE_2C, XL_8, VOL_H, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_3E},
  {BEAT_DLINE2, NOTE_2B, XL_4, VOL_M, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_3E},
  {BEAT_DLINE2, NOTE_2E, XL_3, VOL_M, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_SILENT, NOTE_2C, XL_1 - XL_8 - XL_4 - XL_3 - XL_16, VOL_H, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE},
  {BEAT_DLINE2, NOTE_2C, XL_2, VOL_H, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_2B},
  {BEAT_DLINE2, NOTE_3C, XL_2, VOL_M, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_2E},
  {BEAT_DLINE2, NOTE_2B, XL_2, VOL_H, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_3E},
  {BEAT_DLINE2, NOTE_2C, XL_2, VOL_M, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_DLINE2, NOTE_3E, XL_4, VOL_H, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_3E},
  {BEAT_DLINE2, NOTE_2B, XL_2, VOL_M, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_2B},
  {BEAT_DLINE2, NOTE_3C, XL_2, VOL_H, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_DLINE2, NOTE_2B, XL_4, VOL_M, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_3E},
  {BEAT_DLINE2, NOTE_2E, XL_3, VOL_M, PAN_C, EVENT_FIRE2_1, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },
*/
// L3

 {
  {BEAT_SWEET, NOTE_1C, L_4, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_GLURR, NOTE_1C, L_4, VOL_H, PAN_C, EVENT_FIRE3_2, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_SWEET, NOTE_1DS, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_GLURR, NOTE_1DS, L_4, VOL_H, PAN_C, EVENT_FIRE3_2, EVENT_NONE, EVENT_NONE, NOTE_1AS},
  {BEAT_SWEET, NOTE_1C, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_GLURR, NOTE_1G, L_1 - L_4, VOL_H, PAN_C, EVENT_FIRE3_2, EVENT_NONE, EVENT_NONE, NOTE_2DS},
  {BEAT_SWEET, NOTE_1C, L_4, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_GLURR, NOTE_1G, L_4, VOL_H, PAN_C, EVENT_FIRE3_2, EVENT_NONE, EVENT_NONE, NOTE_2DS},
  {BEAT_SWEET, NOTE_1C, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_GLURR, NOTE_1DS, L_4, VOL_H, PAN_C, EVENT_FIRE3_2, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_SWEET, NOTE_1F, L_1, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_SWEET, NOTE_0G, L_4, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_GLURR, NOTE_2C, L_4, VOL_H, PAN_C, EVENT_FIRE3_2, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_SWEET, NOTE_1C, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_GLURR, NOTE_1C, L_4, VOL_H, PAN_C, EVENT_FIRE3_2, EVENT_NONE, EVENT_NONE, NOTE_1AS},
  {BEAT_SWEET, NOTE_1DS, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_GLURR, NOTE_1G, L_1 - L_4, VOL_H, PAN_C, EVENT_FIRE3_2, EVENT_NONE, EVENT_NONE, NOTE_2DS},
  {BEAT_SWEET, NOTE_1DS, L_4, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_GLURR, NOTE_1G, L_4, VOL_H, PAN_C, EVENT_FIRE3_2, EVENT_NONE, EVENT_NONE, NOTE_2DS},
  {BEAT_SWEET, NOTE_1C, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_GLURR, NOTE_1DS, L_4, VOL_H, PAN_C, EVENT_FIRE3_2, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_SWEET, NOTE_0AS, L_1, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },


/* {
  {BEAT_SWEET, NOTE_2C, L_2, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SWEET, NOTE_2DS, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SWEET, NOTE_2C, L_1, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SWEET, NOTE_2C, L_2, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SWEET, NOTE_2C, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_SWEET, NOTE_2F, L_1, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },*/


 {
  {BEAT_DRUM4, NOTE_1G, L_1 + L_2 + L_2, VOL_M, PAN_C, EVENT_PULSE1, EVENT_PULSE, EVENT_NONE, NOTE_3C},
  {BEAT_DRUM4, NOTE_1C, L_1 + L_2 + L_2, VOL_M, PAN_C, EVENT_PULSE2, EVENT_PULSE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_DRUM4, NOTE_1G, L_1, VOL_M, PAN_C, EVENT_PULSE1, EVENT_PULSE, EVENT_NONE, NOTE_3C},
  {BEAT_CYMBAL1, NOTE_0G, L_4, VOL_H, PAN_C, EVENT_PULSE2, EVENT_PULSE, EVENT_NONE, NOTE_3C},
  {BEAT_CYMBAL1, NOTE_2C, L_2 + L_4, VOL_H, PAN_C, EVENT_PULSE2, EVENT_PULSE, EVENT_NONE, NOTE_3C},
  {BEAT_DRUM4, NOTE_1C, L_1, VOL_M, PAN_C, EVENT_PULSE2, EVENT_PULSE, EVENT_NONE, NOTE_3C},
  {BEAT_CYMBAL1, NOTE_0G, L_4, VOL_H, PAN_C, EVENT_PULSE1, EVENT_PULSE, EVENT_NONE, NOTE_3C},
  {BEAT_CYMBAL1, NOTE_2C, L_2 + L_4, VOL_H, PAN_C, EVENT_PULSE1, EVENT_PULSE, EVENT_NONE, NOTE_3C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_XLINE, NOTE_3C, L_2, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_2AS},
  {BEAT_XLINE2, NOTE_2AS, L_2 - 3, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2DS},
  {BEAT_XLINE, NOTE_2G, L_6, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_2AS},
  {BEAT_XLINE2, NOTE_2FS, L_3 - 2, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_XLINE, NOTE_2F, L_6, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_XLINE2, NOTE_2DS, L_3, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2AS},
  {BEAT_XLINE, NOTE_2C, L_3 + 2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_2E},
  {BEAT_XLINE2, NOTE_1AS, L_2, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_XLINE, NOTE_2C, L_2, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_2DS},
  {BEAT_XLINE2, NOTE_2DS, L_2, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2G},
  {BEAT_XLINE, NOTE_2FS, L_6, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_2AS},
  {BEAT_XLINE2, NOTE_2G, L_3 - 2, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2AS},
  {BEAT_XLINE, NOTE_2AS, L_6, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_2G},
  {BEAT_XLINE2, NOTE_2G, L_3 - 2, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_XLINE, NOTE_2F, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_2D},
  {BEAT_XLINE, NOTE_1AS, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_XLINE2, NOTE_2C, L_3, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2DS},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_XLINE, NOTE_2G, L_2, VOL_H, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_2DS},
  {BEAT_XLINE2, NOTE_2AS, L_2, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2DS},
  {BEAT_XLINE, NOTE_3C, L_6, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_2AS},
  {BEAT_XLINE2, NOTE_3C, L_3 - 2, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2G},
  {BEAT_XLINE, NOTE_3DS, L_6, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_2G},
  {BEAT_XLINE2, NOTE_3C, L_3 - 2, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_XLINE, NOTE_3DS, L_2, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_2D},
  {BEAT_XLINE, NOTE_3C, L_4, VOL_M, PAN_C, EVENT_NONE, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_XLINE2, NOTE_2G, L_3, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2DS},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

// stage 4 beat
/* {

  {BEAT_DRUM3, NOTE_1G, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_CYMBAL1, NOTE_1G, 7, VOL_M, PAN_C, EVENT_FIRE4_1, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM3, NOTE_2C, 9, VOL_H, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_CYMBAL1, NOTE_0D, L_4, VOL_M, PAN_C, EVENT_FIRE4_2, EVENT_NONE, EVENT_NONE},
  {BEAT_DRUM4, NOTE_1C, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_CYMBAL1, NOTE_1G, L_2 - 1, VOL_H, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},

  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },
*/
 {
  {BEAT_STAGE4, NOTE_1G, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_FIRE4_2, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1G, L_2, VOL_H - 60, PAN_C - 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1G, L_2, VOL_H - 120, PAN_C + 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1G, L_2, VOL_H - 180, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1G, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_FIRE4_2, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1G, L_2, VOL_H - 60, PAN_C - 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1G, L_2, VOL_H - 120, PAN_C + 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1G, L_2, VOL_H - 180, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_STAGE4, NOTE_1C, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_FIRE4_2, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1C, L_2, VOL_H - 80, PAN_C - 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1C, L_2, VOL_H - 160, PAN_C + 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1C, L_2, VOL_H - 200, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1C, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_FIRE4_2, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1C, L_2, VOL_H - 80, PAN_C - 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1C, L_2, VOL_H - 160, PAN_C + 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1C, L_2, VOL_H - 200, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_STAGE4, NOTE_1AS, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_FIRE4_2, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1AS, L_2, VOL_H - 80, PAN_C - 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1AS, L_2, VOL_H - 160, PAN_C + 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1AS, L_2, VOL_H - 200, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1AS, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_FIRE4_2, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1AS, L_2, VOL_H - 80, PAN_C - 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1AS, L_2, VOL_H - 160, PAN_C + 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1AS, L_2, VOL_H - 200, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_STAGE4, NOTE_1G, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_FIRE4_2, EVENT_NONE},
  {BEAT_STAGE4, NOTE_2G, L_2, VOL_H - 60, PAN_C - 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1G, L_2, VOL_H - 120, PAN_C + 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_2G, L_2, VOL_H - 180, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1G, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_FIRE4_2, EVENT_NONE},
  {BEAT_STAGE4, NOTE_2G, L_2, VOL_H - 60, PAN_C - 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1G, L_2, VOL_H - 120, PAN_C + 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_2G, L_2, VOL_H - 180, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_STAGE4, NOTE_1C, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_FIRE4_2, EVENT_NONE},
  {BEAT_STAGE4, NOTE_2C, L_2, VOL_H - 80, PAN_C - 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1C, L_2, VOL_H - 160, PAN_C + 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_2C, L_2, VOL_H - 200, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1C, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_FIRE4_2, EVENT_NONE},
  {BEAT_STAGE4, NOTE_2C, L_2, VOL_H - 80, PAN_C - 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1C, L_2, VOL_H - 160, PAN_C + 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_2C, L_2, VOL_H - 200, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_STAGE4, NOTE_1AS, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_FIRE4_2, EVENT_NONE},
  {BEAT_STAGE4, NOTE_2AS, L_2, VOL_H - 80, PAN_C - 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1AS, L_2, VOL_H - 160, PAN_C + 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_2AS, L_2, VOL_H - 200, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1AS, L_2, VOL_H, PAN_C, EVENT_PULSE, EVENT_FIRE4_2, EVENT_NONE},
  {BEAT_STAGE4, NOTE_2AS, L_2, VOL_H - 80, PAN_C - 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_1AS, L_2, VOL_H - 160, PAN_C + 40, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_STAGE4, NOTE_2AS, L_2, VOL_H - 200, PAN_C, EVENT_PULSE, EVENT_NONE, EVENT_NONE},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },


 {
  {BEAT_MULTI, NOTE_1C, L_2, VOL_L, PAN_C, EVENT_FIRE4_1, EVENT_NONE, EVENT_NONE, NOTE_1G},
  {BEAT_MULTI, NOTE_1G, L_2, VOL_M, PAN_C, EVENT_FIRE4_1, EVENT_NONE, EVENT_NONE, NOTE_1AS},
  {BEAT_MULTI, NOTE_1AS, L_2, VOL_L, PAN_C, EVENT_FIRE4_1, EVENT_NONE, EVENT_NONE, NOTE_1C},
  {BEAT_MULTI, NOTE_1C, L_2, VOL_L, PAN_C, EVENT_FIRE4_1, EVENT_NONE, EVENT_NONE, NOTE_1G},
  {BEAT_MULTI, NOTE_1DS, L_2, VOL_M, PAN_C, EVENT_FIRE4_1, EVENT_NONE, EVENT_NONE, NOTE_1C},
  {BEAT_MULTI, NOTE_1C, L_2, VOL_L, PAN_C, EVENT_FIRE4_1, EVENT_NONE, EVENT_NONE, NOTE_1AS},
  {BEAT_MULTI, NOTE_1G, L_2, VOL_M, PAN_C, EVENT_FIRE4_1, EVENT_NONE, EVENT_NONE, NOTE_1G},
  {BEAT_MULTI, NOTE_1C, L_2, VOL_L, PAN_C, EVENT_FIRE4_1, EVENT_NONE, EVENT_NONE, NOTE_1C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },



/*
 {
  {BEAT_XLINE, NOTE_3C, L_2, VOL_H, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2AS},
  {BEAT_XLINE2, NOTE_2AS, L_2 - 3, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_3C},
  {BEAT_XLINE, NOTE_2G, L_6, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2AS},
  {BEAT_XLINE2, NOTE_2FS, L_3 - 2, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2D},
  {BEAT_XLINE, NOTE_2F, L_6, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_XLINE2, NOTE_2DS, L_3, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_1B},
  {BEAT_XLINE, NOTE_2C, L_3 + 2, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2E},
  {BEAT_XLINE2, NOTE_1AS, L_2, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },

 {
  {BEAT_XLINE, NOTE_2C, L_2, VOL_H, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2DS},
  {BEAT_XLINE2, NOTE_2DS, L_2, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2G},
  {BEAT_XLINE, NOTE_2FS, L_6, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2AS},
  {BEAT_XLINE2, NOTE_2G, L_3 - 2, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_XLINE, NOTE_2AS, L_6, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2G},
  {BEAT_XLINE2, NOTE_2G, L_3 - 2, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2DS},
  {BEAT_XLINE, NOTE_2F, L_2, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2D},
  {BEAT_XLINE, NOTE_1AS, L_4, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2C},
  {BEAT_XLINE2, NOTE_2C, L_3, VOL_M, PAN_C, EVENT_FIRE3_1, EVENT_NONE, EVENT_NONE, NOTE_2DS},
  {BEAT_END, 0,L_4,0, EVENT_NONE, EVENT_NONE, EVENT_NONE},
 },
*/

};

#define SUBMUSICS 4

int music_pos;
int overmusic_pos;
int to_change_music;
int submusic_playing [SUBMUSICS];
int submusic_pos [SUBMUSICS];
int submusic_count [SUBMUSICS];
int submusic_finished [SUBMUSICS];

int to_play_beat [SUBMUSICS];
int to_play_tone [SUBMUSICS];
int to_play_alt_tone [SUBMUSICS];
int to_play_vol [SUBMUSICS];
int to_play_pan [SUBMUSICS];

//int which_music;
//int change_music; // when current music finishes, change.

void load_sample_in(int samp, const char *sfile, int direct);


void play_beat(int beat, int f, int vol, int pan, int alt_f, int ptone, int palt_tone);



/*
Call at startup of program.
*/
void init_sound(void)
{

   options.sound_mode = get_config_int("Misc", "StereoMode", SOUNDMODE_STEREO);
   // defaults to stereo in playing functions as well

// first we'll populate the tone array with the right frequencies:
   int i, j;
   float t;
   for (i = 0; i < NO_TONES; i ++)
   {
    t = (float) BASE_TONE;
    for (j = 0; j < i; j ++)
    {
     t *= (float) 1.059463094359;//(1000 + (1000 / 18)) / 1000;
    }
    tone [i] = t;
    // saves me from having to remember how to use the pow function
   }

   reserve_voices(16, 0); // not sure this is necessary
   if (install_sound (DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) == -1)
   {
    exit(1); // don't bother with proper error handling yet. This should just disable sound.
   }
   set_volume(255, 0);

   load_sample_in(WAV_FIRE, "fire", DIRECT_WAV);
   load_sample_in(WAV_BLOP, "blop", DIRECT_WAV);
   load_sample_in(WAV_SWBEAM, "swbeam", DIRECT_WAV);
   load_sample_in(WAV_SCATTER, "scatter", DIRECT_WAV);
   load_sample_in(WAV_MGUN, "mgun", DIRECT_WAV);
   load_sample_in(WAV_CANNON, "cannon", DIRECT_WAV);
   load_sample_in(WAV_BANG, "bang", DIRECT_WAV);
   load_sample_in(WAV_RECT, "rect", DIRECT_WAV);
   load_sample_in(WAV_RECT2, "rect2", DIRECT_WAV);
   load_sample_in(WAV_WHOOSH, "whoosh", DIRECT_WAV);
   load_sample_in(WAV_P_BANG, "p_bang", DIRECT_WAV);
   load_sample_in(WAV_WORMS, "worms", DIRECT_WAV);
   load_sample_in(WAV_MOUTH, "mouth", DIRECT_WAV);
   load_sample_in(WAV_LWBEAM, "lwbeam", DIRECT_WAV);

   load_sample_in(WAV_LEVEL, "level", DIRECT_WAV);
   load_sample_in(WAV_EXTRA, "extra", DIRECT_WAV);
/*   load_sample_in(WAV_STAGE1, "stage1", DIRECT_WAV);
   load_sample_in(WAV_STAGE2, "stage2", DIRECT_WAV);
   load_sample_in(WAV_STAGE3, "stage3", DIRECT_WAV);
   load_sample_in(WAV_STAGE4_2, "stage4", DIRECT_WAV);*/

   load_sample_in(WAV_FLUTE, "flute", DIRECT_BEAT);
   load_sample_in(WAV_DRUM1, "drum1", DIRECT_BEAT);
   load_sample_in(WAV_DRUM2, "drum2", DIRECT_BEAT);
   load_sample_in(WAV_DRUM3, "drum3", DIRECT_BEAT);
   load_sample_in(WAV_DRUM4, "drum4", DIRECT_BEAT);
   load_sample_in(WAV_CYMBAL1, "cymbal1", DIRECT_BEAT);
   load_sample_in(WAV_LINE1, "line1", DIRECT_BEAT);
   load_sample_in(WAV_LINE2, "line2", DIRECT_BEAT);
   load_sample_in(WAV_NICE, "voice", DIRECT_BEAT);
   load_sample_in(WAV_NICE2, "nice2", DIRECT_BEAT);
   load_sample_in(WAV_SAW, "saw", DIRECT_BEAT);
   load_sample_in(WAV_BLIP, "blip", DIRECT_BEAT);
   load_sample_in(WAV_SQUARE, "square", DIRECT_BEAT);
   load_sample_in(WAV_LONG, "long", DIRECT_BEAT);
   load_sample_in(WAV_LONG2, "long2", DIRECT_BEAT);
   load_sample_in(WAV_XLINE, "xline", DIRECT_BEAT);
   load_sample_in(WAV_FLUTE2_S, "flute2_s", DIRECT_BEAT);
   load_sample_in(WAV_FLUTE2_L, "flute2_l", DIRECT_BEAT);
   load_sample_in(WAV_FLUTE_L, "flute_l", DIRECT_BEAT);
   load_sample_in(WAV_PIANO, "piano", DIRECT_BEAT);
   load_sample_in(WAV_PAN, "pan", DIRECT_BEAT);
   load_sample_in(WAV_STRING, "string", DIRECT_BEAT);
   load_sample_in(WAV_DLINE, "dline", DIRECT_BEAT);
   load_sample_in(WAV_SYNTH, "synth", DIRECT_BEAT);
   load_sample_in(WAV_FOOD, "food", DIRECT_BEAT);
   load_sample_in(WAV_LIGHT, "light", DIRECT_BEAT);
   load_sample_in(WAV_BEAM, "beam", DIRECT_BEAT);
   load_sample_in(WAV_ARP, "arp", DIRECT_BEAT);
   load_sample_in(WAV_LINE3, "line3", DIRECT_BEAT);
   load_sample_in(WAV_STAGE4, "stage4", DIRECT_BEAT);
   load_sample_in(WAV_MULTI, "multi", DIRECT_BEAT);
   load_sample_in(WAV_MULTI2, "multi2", DIRECT_BEAT);
   load_sample_in(WAV_THING4, "thing4", DIRECT_BEAT);
   load_sample_in(WAV_SPINNER, "spinner", DIRECT_BEAT);
   load_sample_in(WAV_WALKER, "walker", DIRECT_BEAT);

}

// Called at startup of each game
void init_beat(void)
{

 music_pos = 0;
// which_music = MUSIC_L1_1;
// change_music = 0;

 int i;

 for (i = 0; i < SUBMUSICS; i ++)
 {
  submusic_pos [i] = 0;
  submusic_count [i] = 5;
  submusic_finished [i] = 0;
  to_play_beat [i] = BEAT_NONE;

 }
}

// called at startup of new level
void init_beat_new_level(void)
{

 music_pos = 0;
// which_music = OVERMUSIC_L1_1;
 //change_music = 0;
 switch(arena.level)
 {
  default:
  case 1:
   overmusic_pos = OVERMUSIC_L1_1;
   break;
  case 2:
   overmusic_pos = OVERMUSIC_L2_1;
   break;
  case 3:
   overmusic_pos = OVERMUSIC_L3_1;
   break;
  case 4:
   overmusic_pos = OVERMUSIC_L4_1;
   break;
 }
//   overmusic_pos = OVERMUSIC_L2_1;


 to_change_music = -1;



 int i;

 for (i = 0; i < SUBMUSICS; i ++)
 {
  submusic_playing [i] = SUBMUSIC_EMPTY;
  submusic_pos [i] = 0;
  submusic_count [i] = 0;
  submusic_finished [i] = 0;
  to_play_beat [i] = BEAT_NONE;
 }

 for (i = 0; i < NO_DONE; i ++)
 {
  synch_done [i] = 0;
 }

}


void run_beat(void)
{

 int i;

 for (i = 0; i < NO_EVENTS; i ++)
 {
  synch_ready [i] = 0;
 }

// char go_to_next = 0;

 for (i = 0; i < SUBMUSICS; i ++)
 {
  if (to_play_beat [i] != BEAT_NONE)
  {
   play_beat(to_play_beat [i], tone [to_play_tone [i]], to_play_vol [i], to_play_pan [i], tone [to_play_alt_tone [i]], to_play_tone [i], to_play_alt_tone [i]);
   to_play_beat [i] = BEAT_NONE;
  }
//  if (submusic_count [i] > 0)
//   go_to_next = 0;
 }
  if (submusic [submusic_playing [0]] [submusic_pos [0]] [SM_BEAT] == BEAT_END
      && submusic_count [0] <= 0)
      {
        music_pos ++;
        if (music [overmusic_pos] [music_pos] [0] == SUBMUSIC_END)
        {
         music_pos = 0;
        }
        if (to_change_music != -1)
        {
         overmusic_pos = to_change_music;
         to_change_music = -1;
        }
        for (i = 0; i < SUBMUSICS; i ++)
        {
         submusic_pos [i] = 0;
         submusic_count [i] = 0;
         submusic_playing [i] = music [overmusic_pos] [music_pos] [i];
        }


   //go_to_next = 1;
      }




 for (i = 0; i < SUBMUSICS; i ++)
 {
   if (submusic_playing [i] == SUBMUSIC_EMPTY)
    continue;   // remember to set finished to 1 when setting submusic to _empty!!!
   submusic_count [i] --;
   // if count == 1, synch_events!
   if (submusic_count [i] <= 0)
   {
    if (submusic [submusic_playing [i]] [submusic_pos [i]] [SM_BEAT] == BEAT_END)
    {
//     if (go_to_next == 1) // makes sure all submusics are aligned
//      submusic_pos [i] = 0;
     // we've finished the submusic, including any pause at the end, so set a new submusic here
     continue;
    }
    synch_ready [submusic [submusic_playing [i]] [submusic_pos [i]] [SM_EVENT1]] = 1;
    synch_ready [submusic [submusic_playing [i]] [submusic_pos [i]] [SM_EVENT2]] = 1;
    synch_ready [submusic [submusic_playing [i]] [submusic_pos [i]] [SM_EVENT3]] = 1;
    to_play_beat [i] = submusic [submusic_playing [i]] [submusic_pos [i]] [SM_BEAT];
    to_play_tone [i] = submusic [submusic_playing [i]] [submusic_pos [i]] [SM_TONE];
    to_play_alt_tone [i] = submusic [submusic_playing [i]] [submusic_pos [i]] [SM_ALT_TONE];
    to_play_vol [i] = submusic [submusic_playing [i]] [submusic_pos [i]] [SM_VOL];
    to_play_pan [i] = submusic [submusic_playing [i]] [submusic_pos [i]] [SM_PAN];
/*    play_beat(submusic [submusic_playing [i]] [submusic_pos [i]] [SM_BEAT],
        tone [submusic [submusic_playing [i]] [submusic_pos [i]] [SM_TONE]],
        submusic [submusic_playing [i]] [submusic_pos [i]] [SM_VOL],
        submusic [submusic_playing [i]] [submusic_pos [i]] [SM_PAN]);*/
    submusic_count [i] = submusic [submusic_playing [i]] [submusic_pos [i]] [SM_LENGTH];
//    if (arena.level == 3)
//     submusic_count [i] = submusic [submusic_playing [i]] [submusic_pos [i]] [SM_LENGTH] * 0.8;
    submusic_pos [i] ++;

   }
//   if (submusic_pos [i]

 }

}

void play_beat(int beat, int f, int vol, int pan, int alt_f, int ptone, int palt_tone)
{
 switch(beat)
 {
  case BEAT_BASIC:
   if (synch_done [DONE_SWOOPER1_FIRE])
   {
    play_effectwfvp(WAV_FLUTE, f, vol, pan);
    synch_done [DONE_SWOOPER1_FIRE] = 0;
   }
     else
      play_effectwfvp(WAV_LINE1, f, vol, pan);
   break;
  case BEAT_LINE1:
/*   if (synch_done [DONE_SWOOPER1_FIRE])
   {
    play_effectwfvp(WAV_FLUTE, f, vol, pan);
    synch_done [DONE_SWOOPER1_FIRE] = 0;
   }
     else*/
      play_effectwfvp(WAV_LINE1, f, vol, pan);
   break;
  case BEAT_LINE2:
/*   if (synch_done [DONE_SWOOPER1_FIRE])
   {
    play_effectwfvp(WAV_FLUTE, f, vol, pan);
    synch_done [DONE_SWOOPER1_FIRE] = 0;
   }
     else*/
      play_effectwfvp(WAV_LINE2, f, vol, pan);
   break;
  case BEAT_SLINE:
   if (synch_done [DONE_SWOOPER1_FIRE] & FIRE1_DIVER1)
   {
    if (ptone > 5)
     play_effectwfvp(WAV_SQUARE, tone [ptone - 5], vol, pan);
   }
   if (synch_done [DONE_SWOOPER1_FIRE] & FIRE1_SWOOPER2)
   {
    if (ptone > 5)
     play_effectwfvp(WAV_BLIP, tone [ptone - 5], vol, pan);
    if (ptone > 8)
     play_effectwfvp(WAV_BLIP, tone [ptone - 8], vol, pan);
   }
   if (synch_done [DONE_SWOOPER1_FIRE] & FIRE1_SWOOPER1)
   {
    play_effectwfvp(WAV_BLIP, f, vol, pan);
   }
   if (synch_done [DONE_SWOOPER1_FIRE] & FIRE1_DARTER1)
   {
    play_effectwfvp(WAV_SAW, alt_f, vol, pan);
   }
   if (synch_done [DONE_SWOOPER1_FIRE] & FIRE1_DARTER2)
   {
     play_effectwfvp(WAV_FLUTE, tone [palt_tone], vol, pan);
    if (ptone > 5)
     play_effectwfvp(WAV_SAW, tone [ptone - 5], 150, pan);
     //    if (palt_tone > 5)
/*     play_effectwfvp(WAV_SAW, tone [palt_tone + 4], vol, pan);
    if (palt_tone > 5)
     play_effectwfvp(WAV_SAW, tone [palt_tone - 5], vol, pan);*/
   }
   if (synch_done [DONE_SWOOPER1_FIRE] & FIRE1_CARRIER1)
   {
    play_effectwfvp(WAV_SQUARE, alt_f * 2, vol / 2, pan);
   }
   if (synch_done [DONE_SWOOPER1_FIRE] & FIRE1_BOSS1_2)
   {
     play_effectwfvp(WAV_PAN, tone [palt_tone], vol, pan);
   }
   synch_done [DONE_SWOOPER1_FIRE] = 0;
   break;
  case BEAT_DLINE2:
   if (synch_done [DONE_FIRE2_1])
   {
    play_effectwfvp(WAV_LINE3, alt_f, vol, pan);
//    play_effectwfvp(WAV_LINE1, alt_f / 2, vol, pan);
    synch_done [DONE_FIRE2_1] = 0;
   }
     else
      play_effectwfvp(WAV_LINE2, f, vol, pan);
   break;
  case BEAT_NICE:
   if (synch_done [DONE_STOPPER1_FIRE] & FIRE1_BOSS1_1)
   {
    play_effectwfvp(WAV_NICE, alt_f, vol, pan);
    synch_done [DONE_STOPPER1_FIRE] = 0;
   }
   if (synch_done [DONE_STOPPER1_FIRE] & 1)
   {
    play_effectwfvp(WAV_NICE, f, vol, pan);
    synch_done [DONE_STOPPER1_FIRE] = 0;
   }
   break;
  case BEAT_DRUM1:
   play_effectwfvp(WAV_DRUM1, f, vol, pan);
   break;
  case BEAT_DRUM2:
   play_effectwfvp(WAV_DRUM2, f, vol, pan);
   break;
  case BEAT_DRUM3:
   play_effectwfvp(WAV_DRUM3, f, vol, pan);
   break;
  case BEAT_DRUM4:
   play_effectwfvp(WAV_DRUM4, f, vol, pan);
   break;
  case BEAT_CYMBAL1:
   play_effectwfvp(WAV_CYMBAL1, f, vol, pan);
   break;
  case BEAT_LONG:
   play_effectwfvp(WAV_LONG, f, vol, pan);
   break;
  case BEAT_LONG2:
   play_effectwfvp(WAV_LONG2, f, vol, pan);
   break;
  case BEAT_SWEET:
   play_effectwfvp(WAV_PIANO, f * 2, vol, pan);
//   play_effectwfvp(WAV_STRING, f * 2, vol, pan);
   break;
  case BEAT_XLINE:
   play_effectwfvp(WAV_FLUTE, f, vol, pan);
   break;
  case BEAT_XLINE2:
   if (synch_done [DONE_FIRE3_1] & FIRE3_SMALL)
    play_effectwfvp(WAV_FLUTE, f, vol, pan);
   if (synch_done [DONE_FIRE3_1] & FIRE3_MEGA)
    play_effectwfvp(WAV_STRING, alt_f * 2, vol, pan);
   if (synch_done [DONE_FIRE3_1] & FIRE3_BOSS3_1)
    play_effectwfvp(WAV_STRING, alt_f * 2, vol, pan);
   if (synch_done [DONE_FIRE3_1] & FIRE3_BOSS3_2)
    play_effectwfvp(WAV_FLUTE, f / 2, 250, pan);
   synch_done [DONE_FIRE3_1] = 0;
   break;
  case BEAT_GLURR:
   if (synch_done [DONE_FIRE3_2] & FIRE3_SMALL2)
    play_effectwfvp(WAV_FLUTE, f * 2, vol, pan);
   if (synch_done [DONE_FIRE3_2] & FIRE3_LARGER)
    play_effectwfvp(WAV_PIANO, f * 2, vol, pan);
   if (synch_done [DONE_FIRE3_2] & FIRE3_LARGER2)
    play_effectwfvp(WAV_SQUARE, alt_f, 150, pan);
   if (synch_done [DONE_FIRE3_2] & FIRE3_WINGS)
    play_effectwfvp(WAV_PAN, alt_f * 2, vol, pan);
   if (synch_done [DONE_FIRE3_2] & FIRE3_WINGS2)
    play_effectwfvp(WAV_PAN, alt_f, vol, pan);
   if (synch_done [DONE_FIRE3_2] & FIRE3_BOSS3_3)
    play_effectwfvp(WAV_PAN, f, 250, pan);
   if (synch_done [DONE_FIRE3_2] & FIRE3_BOSS3_4)
    play_effectwfvp(WAV_SQUARE, alt_f, 150, pan);
   synch_done [DONE_FIRE3_2] = 0;
   break;
  case BEAT_XLINE3:
   if (synch_done [DONE_FIRE3_1] & FIRE3_SMALL)
    play_effectwfvp(WAV_FLUTE, tone [NOTE_2C], vol, pan);
   synch_done [DONE_FIRE3_1] = 0;
   break;
  case BEAT_FLUTE2_S:
   play_effectwfvp(WAV_FLUTE2_S, f, vol, pan);
   break;
  case BEAT_FLUTE2_L:
   play_effectwfvp(WAV_FLUTE2_L, f, vol, pan);
   break;
  case BEAT_FLUTE:
   play_effectwfvp(WAV_FLUTE, f, vol, pan);
   break;
  case BEAT_FLUTE_L:
   play_effectwfvp(WAV_FLUTE_L, f, vol, pan);
   break;


  case BEAT_SYNTH:
   if (synch_done [DONE_FIRE2_2] & FIRE2_CRUISER2)
    play_effectwfvp(WAV_SYNTH, f * 2, vol, pan);
   if (synch_done [DONE_FIRE2_2] & FIRE2_CRUISER3)
    play_effectwfvp(WAV_LIGHT, f * 2, 250, pan);
   if (synch_done [DONE_FIRE2_2] & FIRE2_CRUISER1)
    play_effectwfvp(WAV_FOOD, f, vol, pan);
   if (synch_done [DONE_FIRE2_2] & FIRE2_BEAMER)
    play_effectwfvp(WAV_BEAM, f, vol, pan);
   if (synch_done [DONE_FIRE2_2] & FIRE2_CRUISER4)
    play_effectwfvp(WAV_BEAM, f, vol, pan);
   if (synch_done [DONE_FIRE2_2] & FIRE2_SHOOTER)
    play_effectwfvp(WAV_ARP, f * 2, 250, pan);
   if (synch_done [DONE_FIRE2_2] & FIRE2_BOSS2_1)
    play_effectwfvp(WAV_LIGHT, f, 250, pan);
   if (synch_done [DONE_FIRE2_2] & FIRE2_BOSS2_2)
    play_effectwfvp(WAV_FOOD, f, vol, pan);
   synch_done [DONE_FIRE2_2] = 0;
   break;

  case BEAT_STAGE4:
   play_effectwfvp(WAV_STAGE4, f, vol, pan);
   if (synch_done [DONE_FIRE4_2] & FIRE4_HUNTER)
     play_effectwfvp(WAV_THING4, f, vol, pan);
   if (synch_done [DONE_FIRE4_2] & FIRE4_WALKER)
     play_effectwfvp(WAV_WALKER, tone [NOTE_1G], 150, pan);
   synch_done [DONE_FIRE4_2] = 0;
   break;
  case BEAT_MULTI:
   if (synch_done [DONE_FIRE4_1] & FIRE4_HOOK)
     play_effectwfvp(WAV_MULTI, f * 2, vol, pan);
   if (synch_done [DONE_FIRE4_1] & FIRE4_DROPPER)
   {
    if (grand(3) == 0)
     play_effectwfvp(WAV_MULTI2, alt_f * 4, vol, pan);
      else
       play_effectwfvp(WAV_MULTI2, alt_f * 2, vol, pan);
   }
   if (synch_done [DONE_FIRE4_1] & FIRE4_SPINNER)
   {
//    if (grand(3) == 0)
     play_effectwfvp(WAV_SPINNER, tone [NOTE_1C], 150, pan);
//      else
//       play_effectwfvp(WAV_SPINNER, tone [NOTE_1G], 150, pan);
   }
   if (synch_done [DONE_FIRE4_1] & FIRE4_HOOK2)
     play_effectwfvp(WAV_MULTI, f * 1, vol, pan);
   synch_done [DONE_FIRE4_1] = 0;
   break;
 }

}



void change_music(int mto)
{
  to_change_music = mto;
}







/*
Loads a .wav file. Should be in the .wavs subdirectory
*/
void load_sample_in(int samp, const char *sfile, int direct)
{

 char sfile_name [50];

 if (direct == DIRECT_WAV)
  strcpy(sfile_name, ".//wavs//");
   else
    strcpy(sfile_name, ".//beat//");
 strcat(sfile_name, sfile);
 strcat(sfile_name, ".wav");

 sounds [samp] = load_sample(sfile_name);

 if (sounds [samp] == NULL)
 {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Error: Unable to load sound file: %s", sfile_name);
      exit(1);
 }
}


/*
Pass e.g. WAV_FIRE to this and it plays it
*/
void play_effect(int sample)
{

 play_sample(sounds [sample], 200, 127, 1000, 0);

}

/*
plays sample at frequency f (normal is 1000), volume v (255 is max), x position x (middle is 127)
*/
void play_effectwfvp(int sample, int f, int v, int pan)
{

 switch(options.sound_mode)
 {
  case SOUNDMODE_MONO:
   pan = 127;   break;
  case SOUNDMODE_REVERSED:
   pan = 255 - pan;   break;
 }

 play_sample(sounds [sample], v, pan, f, 0);

}


/*
plays sample at frequency f (normal is 1000), volume v (255 is max), x position x (middle is 127)
*/
void play_effectwfvx(int sample, int f, int v, int x)
{

// int pan = x / 2500; // this gives us a # from 0 to 255, from the left of the screen to the right. For stereo

 int pan = x / 5030; // this gives us a # from 0 to 255, from the left of the screen to the right. For stereo
 pan += 64;

 switch(options.sound_mode)
 {
  case SOUNDMODE_MONO:
   pan = 127;   break;
  case SOUNDMODE_REVERSED:
   pan = 255 - pan;   break;
 }

 play_sample(sounds [sample], v, pan, f, 0);

}







