#include <stdio.h>
#include <allegro.h>
#include "Joystick.h"



bool Joystick::Left(bool readkey) {
	if(readkey && !readkey_check()) return false;
	if(num_joysticks > 0) {
		if(joy[0].num_sticks > 0) {
			if(joy[0].stick[0].num_axis > 0) {
				if(joy[0].stick[0].axis[0].pos < 0) {
					dt = 0;
					return true;
				}
			}
		}
	}

	return false;
}



bool Joystick::Right(bool readkey) {
	if(readkey && !readkey_check()) return false;
	if(num_joysticks > 0) {
		if(joy[0].num_sticks > 0) {
			if(joy[0].stick[0].num_axis > 0) {
				if(joy[0].stick[0].axis[0].pos > 0) {
					dt = 0;
					return true;
				}
			}
		}
	}

	return false;
}


bool Joystick::Down(bool readkey) {
	if(readkey && !readkey_check()) return false;
	if(num_joysticks > 0) {
		if(joy[0].num_sticks > 0) {
			if(joy[0].stick[0].num_axis > 1) {
				if(joy[0].stick[0].axis[1].pos > 0) {
					dt = 0;
					return true;
				}
			}
		}
	}

	return false;
}

bool Joystick::Up(bool readkey) {
	if(readkey && !readkey_check()) return false;
	if(num_joysticks > 0) {
		if(joy[0].num_sticks > 0) {
			if(joy[0].stick[0].num_axis > 1) {
				if(joy[0].stick[0].axis[1].pos < 0) {
					dt = 0;
					return true;
				}
			}
		}
	}

	return false;
}



bool Joystick::B0(bool readkey) {
	if(readkey && !readkey_check()) return false;
	if(num_joysticks > 0) 
		if(joy[0].num_buttons > 0)
			if(joy[0].button[0].b) {
				dt = 0;
				return true;
			}

	return false;
}


bool Joystick::LastButton(bool readkey) {
	if(readkey && !readkey_check()) return false;
	if(num_joysticks > 0)
		if(joy[0].num_buttons > 0)
			if(joy[0].button[joy[0].num_buttons-1].b) {
				dt = 0;
				return true;
			}

	return false;
}


bool Joystick::readkey_check() {
	if(dt < 0.333) return false;
	return true;
}