/*    Zonic the Hog.  A silly Sonic-like game written for Speedhack 2007
 *    Copyright (c) 2007 Steven Wallace / Chedda Cheeze
 *    email: steven.t.wallace @ gmail. com
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
 

#ifndef _MAIN_H
#define _MAIN_H

#include <list>
using namespace std;

// Ensures that (b) lies between (a) and (c)
#define SQUEEZE(a, b, c)   ((b)<(a)?(a):((b)>(c)?(c):(b)))


#define RADIUS_OF_INFLUENCE	128
#define MAX_PLAYER_SPEED	750
#define MAX_APPLE_SPEED		1000
#define PLAYER_ACCEL		250
#define PLAYER_REVERSE_ACCEL	750
#define GRAVITY			1250

#define TOTAL_ITEMS 		4
#define ITEM_APPLE		0
#define ITEM_BANANA		1
#define ITEM_EGG		2
#define ITEM_CARROT		3

#define VERSION_STR		"1.1-pre1"


extern bool done;
extern list<class GameComponent*> toProcess;
extern class Game game;
extern class Menu menu;
extern class Cutscene cutscene;
extern class EndOfLevel endoflevel;

extern float desktop_ratio;
extern int fullscreen;
extern struct DATAFILE *data;
extern class Level *level;
extern class Player player, farmer;
extern class Joystick joystick;

extern int win_w, win_h;
extern int fs_w, fs_h;
extern int dw, dh;


extern struct FONT *fMenu, *fTitle, *fDialog;


enum resumeEnumType { GAME, CUTSCENE, EOL };
extern resumeEnumType resumeItem;


extern int setup_screen(int fullscreen);

#endif // _MAIN_H
