/*    Zonic the Hog.  A silly Sonic-like game written for Speedhack 2007
 *    Copyright (c) 2007 Steven Wallace / Chedda Cheeze
 *    email: steven.t.wallace @ gmail. com
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
 


#ifndef _CUTSCENE_H
#define _CUTSCENE_H

#include "GameComponent.h"


struct CS_Bit {
	int speaker;
	char *text;
};




class Cutscene : public GameComponent {
public:
	Cutscene() { currentScene = currentState = 0; selection = 0; }
	~Cutscene() {}

	void LoadScene(int scene) { currentScene = scene; currentState = 0; selection = 0; }
	bool Update(float dt);
	void Draw(struct BITMAP *buffer);
	void Reset() { currentScene = currentState = 0; }
	void GameOver();

private:
	int currentScene;	// Which cutscene we are on
	int currentState;	// Which state of the scene we are in
	int selection;
	int lastScene;
};




#endif // _CUTSCENE_H

