/*    Zonic the Hog.  A silly Sonic-like game written for Speedhack 2007
 *    Copyright (c) 2007 Steven Wallace / Chedda Cheeze
 *    email: steven.t.wallace @ gmail. com
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
 
#include "Object.h"
#include "main.h"
#include <allegro.h>
#include "GlCompat.h"


Object::Object(int x, int y, int type, int idx) {
	this->x = x;
	this->y = y;
	this->type = type;
	this->idx = idx;
}



void Object::Draw(struct BITMAP *buffer, int cx, int cy) {
	int tidx;
	switch(type) {
	case 0:	// BG Object
		tidx = B_BG_00_HEN;
		break;
	}
	gl_draw_sprite(screen, (BITMAP*)data[tidx + idx].dat, x - cx - 32, y - cy - 64);
}



void Object::Deserialize(FILE *f) {
	int data[4];
	fread(data, sizeof(*data), 4, f);
	x = data[0];
	y = data[1];
	idx = data[2];
	type = data[3];
}		



void Object::Serialize(FILE *f) {
	int data[4] = { x, y, idx, type };
	fwrite(data, sizeof(*data), 4, f);
}



