/*    Zonic the Hog.  A silly Sonic-like game written for Speedhack 2007
 *    Copyright (c) 2007 Steven Wallace / Chedda Cheeze
 *    email: steven.t.wallace @ gmail. com
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
 


#ifndef _QUADMAP_H
#define _QUADMAP_H

#include "Serializable.h"
#include "Object.h"
#include <list>
using namespace std;


class QuadMap : public Serializable {
public:
	QuadMap(int right, int bottom, int left=0, int top=0, int maxObjectsPerBin=3);
	virtual ~QuadMap();

	void Insert(Object *obj, bool checkPosition=true);
	bool Remove(Object *obj);
	void Clear();
	QuadMap *GetChild1() { return q1; }
	QuadMap *GetChild2() { return q2; }
	
	void Serialize(FILE *f);
	void Deserialize(FILE *f);
	
	void SetBounds(int left, int top, int right, int bottom);
	void GetObjects(list<Object*> *obj, int left, int top, int right, int bottom);
	int GetSize() { return size; }

protected:
	void Divide();


	list<Object*> object;

	// Boundaries of objects in this quadmap
	int top, right, bottom, left;
	int width, height;
	int maxObjectsPerBin;

	QuadMap *q1, 	// Top and left
		*q2;	// Bottom and right
	int size;	// How many objects are held in this and all its children
};



extern void ListTrim(list<Object*>*, int, int, int, int);



#endif // _QUADMAP_H
