/*    Zonic the Hog.  A silly Sonic-like game written for Speedhack 2007
 *    Copyright (c) 2007 Steven Wallace / Chedda Cheeze
 *    email: steven.t.wallace @ gmail. com
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
 


#ifndef _OBJECT_H
#define _OBJECT_H

#include "Serializable.h"
#include <allegro.h>
#include "main.h"
#include "data.h"

class Object : public Serializable {
public:
	Object() {}
	Object(int x, int y, int type, int idx);
	virtual ~Object() {}
	
	
	void Draw(struct BITMAP *buffer, int cx, int cy);
	
	void SetPosition(int x, int y) { this->x = x; this->y = y; }

	float GetX() { return x; }
	float GetY() { return y; }
	
	void Serialize(FILE *f);	
	void Deserialize(FILE *f);

protected:
	int x, y;		// coordinates of the object
	int idx, type;		// index and type
};



#endif // _OBJECT_H
