/*    Zonic the Hog.  A silly Sonic-like game written for Speedhack 2007
 *    Copyright (c) 2007 Steven Wallace / Chedda Cheeze
 *    email: steven.t.wallace @ gmail. com
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
 


#ifndef _GAME_COMPONENT_H
#define _GAME_COMPONENT_H


#include <vector>
using namespace std;


class GameComponent {
public:
	GameComponent() {}
	virtual ~GameComponent() {}

	virtual void Draw(struct BITMAP *buffer) = 0;
		
	// Returns true if it may have modified the toProcess list, false otherwise
	virtual bool Update(float timeElapsed) = 0;
	void SendKeys(vector<int> *keys) { this->keys = keys; }
	
protected:
	// Always passed to the object as a pointer
	// We are never responsible for this memory
	vector<int> *keys;
};



#endif // _GAME_COMPONENT_H
