#include <allegro.h>
#include <alleggl.h>
#include "Timer.h"
#include "Level.h"
#include "Apple.h"
#include "GlCompat.h"

char *itype[] = { "apple", "banana", "egg", "carrot" };
char *gtype[] = { "grass", "ice", "hay", "wood" };
char *btype[] = { "hen", "chair", "horse", "tree" };
DATAFILE *data;
char fn[80];

int main(int argc, char *argv[]) {
	allegro_init();
	install_allegro_gl();
	set_color_depth(32);
	if(set_gfx_mode(GFX_OPENGL_WINDOWED, 800, 600, 0, 0) != 0) {
		allegro_message("Error setting GFX mode.");
		exit(1);
	}
	
	install_keyboard();
	install_mouse();
	
	Level level;
	if(argc > 1) snprintf(fn, 80, argv[1]);
	else snprintf(fn, 80, "level01.map");
	level.Load(fn);
	
	//BITMAP *buffer = create_bitmap(SCREEN_W, SCREEN_H);
	data = load_datafile("media/zonic.dat");


	Timer timer;
	int cx = 0, cy = 0;
	int type = 0;
	int itemtype = 0;
	int bgtype = 0;
	while(!key[KEY_ESC]) {
		static int mickx, micky;
		
		static int clear_color = makecol(8, 192, 234);
		//clear_to_color(buffer, clear_color);
		glClear(GL_COLOR_BUFFER_BIT);
		float dt = timer.TimeElapsed();
		if(key[KEY_LSHIFT]) dt *= 15;
		
		get_mouse_mickeys(&mickx, &micky);
		if(mouse_b & 1) level.Plot(mouse_x + cx, mouse_y + cy, type);
		if(mouse_b & 2) {
			cx -= mickx;
			cy -= micky;
		}
		
		if(key[KEY_LEFT]) cx -= 500 * dt;
		if(key[KEY_RIGHT]) cx += 500 * dt;
		if(key[KEY_UP]) cy -= 500 * dt;
		if(key[KEY_DOWN]) cy += 500 * dt;
			
		if(key[KEY_S]) level.Save(fn);			
		
		while(keypressed()) {
			switch(readkey() >> 8) {
			case KEY_SPACE:
				level.AddApple(mouse_x + cx, mouse_y + cy, itemtype);
				break;
			
			case KEY_TAB:
				type++;
				if(type > 3) type = 0;
				break;
				
			case KEY_TILDE:
				itemtype++;
				if(itemtype > 3) itemtype = 0;
				break;
				
			case KEY_BACKSPACE:
				bgtype++;
				if(bgtype > 3) bgtype = 0;
				break;
					
			case KEY_ENTER:
				level.AddBgItem(mouse_x + cx, mouse_y + cy, bgtype);
				break;
			
			case KEY_F1:
				level.ClearBgItems();
				printf("BG Items cleared.\n");
				break;
			}
		}
	
		
		level.Draw(screen, cx, cy);
		
		vline(screen, -cx, 0, SCREEN_H, 0);
		hline(screen, 0, -cy, SCREEN_W, 0);
		
		//if(key[KEY_F12]) save_bmp("ed.bmp", buffer, NULL);
		
		// Draw to screen
		textprintf_right_ex(screen, font, SCREEN_W, 0, 0, -1, "Left Click: %s [Tab]", gtype[type]);
		textprintf_right_ex(screen, font, SCREEN_W,10, 0, -1, "Space: %s [~]", itype[itemtype]);
		textprintf_right_ex(screen, font, SCREEN_W,20, 0, -1, "Enter: %s [Backspace]", btype[bgtype]);

		gl_draw_sprite(screen, mouse_sprite, mouse_x, mouse_y);
		//vsync();
		//blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
		allegro_gl_flip();
		rest(1);
	}
	
	
}
END_OF_MAIN()
