/*    Zonic the Hog.  A silly Sonic-like game written for Speedhack 2007
 *    Copyright (c) 2007 Steven Wallace / Chedda Cheeze
 *    email: steven.t.wallace @ gmail. com
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
 
#include <allegro.h>
#include "Cutscene.h"
#include "data.h"
#include "main.h"
#include "GameComponent.h"
#include "Game.h"
#include "GlCompat.h"
#include <alleggl.h>
#include "Menu.h"
#include "EndOfLevel.h"
#include "fudgefont.h"


// todo: how can I make this variable sized and still easy to hardcode in?
CS_Bit bit[4][16] = {
	{
		{0, "Howdy there, I'm Farmer Ted. I have the happiest farm on the planet."}, 
		{0, "All of my animals are well fed and are content to live out their lives..."}, 
		{0, "Even the pigs which we slaughter. I just love bacon!"}, 
		{0, "Speaking of bacon, today is slaughtering day."},
		{0, "I can't wait to eat some pork chops from my prize-winning pig, Zonic."},
		{1, "Not so fast Teddie. I think I prefer living."},
		{1, "Screw you and your utopian farm! I'm going to steal all your food!"},
		{0, "Zonic!  You won't get away with this!"},
		{1, "We'll see about that. Hmm, I think I'll start off by..."},
		{0, "Oh, no! Not the [choice here]"},
		{2, "Farmer Ted's henchpig is right behind you!"},
		{2, "So you better collect as much food as you can..."},
		{2, "...and don't let him catch you!!"},
		{1, "I ain't afraid of no farmer. Let's go!"},
		{-1, 0}
	},
	{
		{0, "You won't get away with this! Return the food and I will spare you!"},
		{1, "Never! I've had enough of you and your lies."},
		{1, "I don't want to be your Christmas dinner. Instead, you shall be mine!"},
		{-1, 0}
	},
	{
		{1, "*Munch*"},
		{1, "*Snort*"},
		{1, "*Snap*"},
		{1, "You know, humans don't taste as good as you'd expect."},
		{1, "Tastes kinda like ham..."},
		{1, "I'm surprised you got this far. Yep, I'm one bad mutha, huh?"},
		{0, "But don't worry, kids, it's all pretend. See? I'm still alive."},
		{1, "Yup. We're good friends. That's all, folks! Hope you enjoyed the game!"},
		{0, "And the cheesy dialogue!"},
		{2, "Hey, I heard that!"},
		{2, "Be sure to check out the band Isaac Jacobs & The Abrahams..."},
		{2, "http://www.zendurl.com/jacobs"},
		{2, "Those kids sure make good music."},
		{-1, 0}
	},
	{
		{0, "You didn't think you were going to get away, did you?"},
		{0, "I absolutely looooooove bacon."},
		{0, "*Slash*"},
		{0, "*Drip*"},
		{0, "*Sizzle*"},
		{0, "*Snarf*"},
	/* 3,6 */	{2, "Would you like to try this level again?"},
		{-1, 0}
	}
};



bool Cutscene::Update(float dt) {
	if(currentScene == 0 && currentState == 8) {
		vector<int>::const_iterator it;
		for(it=keys->begin(); it!=keys->end(); it++) {
			switch(*it) {
			case KEY_UP:
				selection--;
				if(selection < 0) selection = 0;
				break;
				
			case KEY_DOWN:
				selection++;
				if(selection > 2) selection = 2;
				break;
				
			case KEY_ENTER:
				game.SetLevel(selection);
				game.Restart();
				switch(selection) {
				case 0: bit[0][9].text = "Oh, no!  Not the hen house!"; break;
				case 1: bit[0][9].text = "Oh, no!  Not the horse pasture!"; break;
				case 2: bit[0][9].text = "Oh, no!  Not the apple orchard!"; break;
				}
				currentState++;
				resumeItem = GAME;
				break;
			
			case KEY_ESC:
				toProcess.clear();
				toProcess.push_front(&menu);
				return true;
			}
		}
	}
	else if(currentScene == 3 && currentState == 6) {
		if(selection < 0) selection = 0;
		else if(selection > 1) selection = 1;
		vector<int>::const_iterator it;
		for(it=keys->begin(); it!=keys->end(); it++) {
			switch(*it) {
			case KEY_UP:
				selection--;
				if(selection < 0) selection = 1;
				break;
				
			case KEY_DOWN:
				selection++;
				if(selection > 1) selection = 0;
				break;
				
			case KEY_ENTER:
				switch(selection) {
				case 0: // yes
					resumeItem = GAME;
					player.ReplayLevel();
					game.Restart();
					currentScene = lastScene;
					currentState = 0;
					toProcess.clear();
					toProcess.push_back(&game);
					break;
				
				case 1: // no
					resumeItem = CUTSCENE;
					game.Restart();
					player.NewGame();
					currentScene = 0;
					currentState = 0;
					toProcess.clear();
					toProcess.push_back(&menu);
					break;
				}
				return true;
			
			case KEY_ESC:
				toProcess.clear();
				toProcess.push_front(&menu);
				return true;
			}
		}
	}
	
	else {
		if(keys->size() > 0) currentState++;
		vector<int>::const_iterator it;
		for(it=keys->begin(); it!=keys->end(); it++) {
			switch(*it) {
			case KEY_ESC:
				toProcess.clear();
				toProcess.push_front(&menu);
				currentState--;
				return true;
			}
		}
			
		
		if(bit[currentScene][currentState].speaker == -1) {
			toProcess.clear();
			toProcess.push_front(&game);
			currentScene++;
			currentState = 0;
			
			// end of game condition
			if(currentScene == 3) {
				if(menu.GetHiscore() < player.GetScore()) menu.SetHiscore(player.GetScore());

				game.NewGame();
				player.NewGame();
				currentScene = 0;
				resumeItem = CUTSCENE;
				toProcess.clear();
				toProcess.push_back(&menu);
			}
			return true;
		}
	}

	return false;
}



void Cutscene::Draw(BITMAP *buffer) {
	glEnable(GL_TEXTURE_2D);
	
	
	static int pic[3] = { B_PIC_FARMER, B_PIC_PIGGY, B_PIC_HARRY };
	static char *name[3] = { "Farmer Ted", "Zonic the Hog", "Harry Carey" };
	
	if(currentScene == 3) game.Draw(buffer);
	
	my_print(fDialog, SCREEN_W/2, SCREEN_H/2 - 120, TRUE, name[bit[currentScene][currentState].speaker]);
	gl_draw_sprite(buffer, (BITMAP*)data[pic[bit[currentScene][currentState].speaker]].dat, SCREEN_W/2 - 32, SCREEN_H/2 - 80);
	gl_rect(buffer, SCREEN_W/2 - 33, SCREEN_H/2 - 81, SCREEN_W/2 + 32, SCREEN_H/2 - 80 + 64, 0);
	my_print(fDialog, SCREEN_W/2, SCREEN_H/2 + 12, TRUE, bit[currentScene][currentState].text);
	
	
	if(currentScene == 0 && currentState == 8) {
		my_print(fDialog, 70, SCREEN_H/2 + 43 + 20*selection, FALSE, "-->");
		my_print(fMenu, 100, SCREEN_H/2 + 50, FALSE, "Hitting the hen house");
		my_print(fMenu, 100, SCREEN_H/2 + 70, FALSE, "Passing through the horse pastures");
		my_print(fMenu, 100, SCREEN_H/2 + 90, FALSE, "Orbiting the apple orchard");
	}
	else if(currentScene == 3 && currentState == 6) {
		my_print(fDialog, 70, SCREEN_H/2 + 43 + 20*selection, FALSE, "-->");
		my_print(fMenu, 100, SCREEN_H/2 + 50, FALSE, "Yes, please");
		my_print(fMenu, 100, SCREEN_H/2 + 70, FALSE, "No, thank you");
	}
}



void Cutscene::GameOver() {
	lastScene = currentScene;
	currentScene = 3;
}


