/*    Zonic the Hog.  A silly Sonic-like game written for Speedhack 2007
 *    Copyright (c) 2007 Steven Wallace / Chedda Cheeze
 *    email: steven.t.wallace @ gmail. com
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
 


#ifndef _PLAYER_H
#define _PLAYER_H

#include "main.h"

#define IF_LEFT		0
#define IF_RIGHT	1
#define IF_JUMP		2


class Player {
public:
	Player();
	~Player() {}
		
	void Restart();
	bool UpdatePig(float dt);
	bool UpdateAI(float dt);
	bool UpdateGeneric(float dt);
	
	void Draw(struct BITMAP *buffer, int cx, int cy);
	void Jump();
	void GainItem(int item);
	void LoseItem(float dt);
	int CountItems() { int i, total=0; for(i=0; i<TOTAL_ITEMS; i++) total+=items[i]; return total; }
		
	float GetDX() { return dx; }
	float GetDY() { return dy; }
	float GetX() { return x; }
	float GetY() { return y; }
	float GetAngle() { return angle; }
	int GetItem(int item) { return items[item]; }
	int GetScore() { return score; }
	void ReplayLevel() { score = oldscore; }
	void NewGame() { Restart(); score = oldscore = 0; }
	
	bool IsOnScreen(int cx, int cy);



protected:
	float dx, dy;
	float x, y;
	float frame;
	int face;
	float angle;
	int score, oldscore;
	int items[4];

	char inputflag[4];
};




#endif // _PLAYER_H

