/*    Zonic the Hog.  A silly Sonic-like game written for Speedhack 2007
 *    Copyright (c) 2007 Steven Wallace / Chedda Cheeze
 *    email: steven.t.wallace @ gmail. com
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 

 
#include "Menu.h"
#include <allegro.h>
#include <alleggl.h>
#include "fudgefont.h"
#include <vector>
#include "main.h"
#include "Cutscene.h"
#include "GameComponent.h"
#include "EndOfLevel.h"
#include "Game.h"

#ifdef WIN32
#include <winalleg.h>
#include <shellapi.h>
#endif


enum resumeEnumType resumeItem = CUTSCENE;

Menu::Menu() {
	// Instead of making a generic extendable class,
	// this menu will be static
	
	option.push_back("New Game");
	option.push_back("Resume Game");
	option.push_back("Fullscreen Mode");
	option.push_back("Switch to widescreen mode");
	option.push_back("Music Volume: 100%");
	option.push_back("Sound Volume: 100%");
	option.push_back("Launch IJA Website");
	option.push_back("Exit");
	
	selected = 0;
	
	// Read hiscore
	FILE *f = fopen("zonic.hi", "rb");
	if(!f) {
		hiscore = 0;
	}
	else {
		fread(&hiscore, sizeof(hiscore), 1, f);
		fclose(f);
	}
}


Menu::~Menu() {
	FILE *f = fopen("zonic.hi", "wb");
	if(!f) return;
	fwrite(&hiscore, sizeof(hiscore), 1, f);
	fclose(f);
}


static int screenmode=0;

void Menu::ProcessOptions(int selected) {
	switch(selected) {
	case 0:	// New Game
		toProcess.clear();
		cutscene.Reset();
		toProcess.push_front(&cutscene);
		game.NewGame();
		break;
	
	case 1: // Resume Game
		toProcess.clear();
		switch(resumeItem) {
			case GAME: 
				toProcess.push_front(&game);
				game.Unpause();
				break;
			
			case CUTSCENE: 
				toProcess.push_front(&cutscene); 
				break;
			
			case EOL:
				toProcess.push_front(&endoflevel);
				break;
		}
		break;
		
	case 2: // Fullscreen 
		fullscreen = setup_screen(!fullscreen);
		if(fullscreen) option[2] = "Windowed Mode";
		else option[2] = "Fullscreen Mode";
		break;
		
	case 3: // Wide/Std/Tallscreen
		screenmode++;
		if(screenmode > 2) screenmode = 0;
		switch(screenmode) {
			case 0: // Std
				win_w = 800;
				win_h = 600;
				if(desktop_ratio > 4/3.0) {
					fs_h = dh;
					fs_w = (int)(dh * desktop_ratio);
				}
				else if(desktop_ratio < 4/3.0) {
					fs_w = dw;
					fs_h = (int)(dw / desktop_ratio);
				}
				option[3] = "Switch to widescreen mode";
				break;
			
			case 1: // Wide
				win_w = 960;
				win_h = 600;
				fs_h = dh;
				fs_w = (int)(dh * 8 / 5.0);
				option[3] = "Switch to tallscreen mode";
				break;
			
			case 2: // Tall
				win_w = 800;
				win_h = 1280;
				fs_w = dw;
				fs_h = (int)(dw * 8 / 5.0);
				option[3] = "Switch to standard mode";
				break;
		}
		setup_screen(fullscreen);
		break;
	
	case 4: // Music Vol
	case 5: // Sound Vol
		break;
	
	case 6: // Website
		#ifdef WIN32
		ShellExecute(NULL, "open", "http://www.archive.org/details/Isaac_Jacobs_and_the_Abrahams_-_The_Abrahams_Unplugged", NULL, NULL, SW_SHOWNORMAL);
		#else
		system("firefox http://www.archive.org/details/Isaac_Jacobs_and_the_Abrahams_-_The_Abrahams_Unplugged &");	
		#endif
		break;
	
	case 7: // Exit
		done = true;
	}
}


bool Menu::Update(float dt) {
	static char mv_str[80];
	static char sv_str[80];
	static int mv, sv;
	bool ret = false;
	vector<int>::const_iterator it;
	for(it=keys->begin(); it!=keys->end(); it++) {
		switch(*it) {
		case KEY_ENTER:
			ProcessOptions(selected);
			ret = true;
			break;
		
		case KEY_UP:
			selected--;
			if(selected < 0) selected = 0;
			break;
		
		case KEY_DOWN:
			selected++;
			if(selected >= option.size()) selected = option.size()-1;
			break;
			
		case KEY_LEFT:
			switch(selected) {
				case 4: mv -= (int)(500 * dt); break;
				case 5: sv -= (int)(500 * dt); break;
			}
			set_volume(sv, mv);
			break;
		
		case KEY_RIGHT:
			switch(selected) {
				case 4: mv += (int)(500 * dt); break;
				case 5: sv += (int)(500 * dt); break;
			}
			set_volume(sv, mv);
			break;
			
		case KEY_ESC:
			selected = option.size()-1;
			break;
		}
	}
	
	
	get_volume(&sv, &mv);
	snprintf(mv_str, 80, "Music Volume: %0.0f%%", mv/255.0 * 100);
	snprintf(sv_str, 80, "Sound Volume: %0.0f%%", sv/255.0 * 100);

	option[4] = mv_str;
	option[5] = sv_str;
	
	
	return ret;
}



void Menu::Draw(BITMAP *buffer) {
	int h1 = SCREEN_H / 4;
	int SCREEN_W2 = SCREEN_W/2;
	
	my_color(0,0,0);
	my_print(fTitle, SCREEN_W2, 100, TRUE, "Zonic the Hog");
	
	
	int i;
	for(i=0; i<(int)option.size(); i++) 
		my_print(fMenu, SCREEN_W2, h1 + 20*i, TRUE, option[i].c_str());
	
	
	
	my_print(fDialog, SCREEN_W2, h1 - 6 + 20*selected, TRUE,
		"-->                                                                <--");
	
	//textprintf_centre_ex(screen, fMenu, SCREEN_W/2, SCREEN_H * 3 / 4, -1, -1, "High Score: %d", hiscore);
	my_print(fMenu, SCREEN_W2, SCREEN_H * 3 / 4, TRUE, "High Score: %d", hiscore);
	
	
	my_color(255,255,0);
	my_print(font, 0, SCREEN_H-8, FALSE, "(c) Copyright 2007 Chedda Cheeze");
	
	
	// Print type of monitor
	my_print_right(font, SCREEN_W, SCREEN_H-8, "%s monitor detected", desktop_ratio>4/3.0?"Widescreen":(desktop_ratio<4/3.0?"Tallscreen":"Standard"));
}


