/*    Zonic the Hog.  A silly Sonic-like game written for Speedhack 2007
 *    Copyright (c) 2007 Steven Wallace / Chedda Cheeze
 *    email: steven.t.wallace @ gmail. com
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
 
#include <allegro.h>
#include "EndOfLevel.h"
#include "main.h"
#include "Menu.h"
#include "Game.h"
#include "fudgefont.h"


bool EndOfLevel::Update(float dt) {
	timer += dt;
	
	
	
	
	vector<int>::const_iterator it;
	for(it=keys->begin(); it!=keys->end(); it++) {
		switch(*it) {
		case KEY_ESC:
			toProcess.clear();
			toProcess.push_back(&menu);
			resumeItem = EOL;
			return true;
		}
	}
	
	
	
	
	if(timer > 4) {
		// load next level
		// fixes toProcess as well
		game.NextLevel();
		return true;
	}
	return false;
}



void EndOfLevel::Draw(BITMAP *buffer) {
	game.Draw(buffer);
	my_print(fTitle, SCREEN_W/2, SCREEN_H/2, TRUE, "Level Complete!");
}



