/*    Zonic the Hog.  A silly Sonic-like game written for Speedhack 2007
 *    Copyright (c) 2007 Steven Wallace / Chedda Cheeze
 *    email: steven.t.wallace @ gmail. com
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
 
#include "Apple.h"
#include "Game.h"
#include "main.h"
#include <allegro.h>
#include "data.h"
#include "GlCompat.h"
#include <math.h>


Apple::Apple(int x, int y, int type) {
	activated = chasePlayer = false;
	this->x = x;
	this->y = y;
	dx = dy = 0;
	this->type = type;
	valid = true;
}




// Returns true if the apple object can be removed, false otherwise
bool Apple::Update(float dt) {
#ifdef _GAME_
	//printf("Updating apple..\n");
	float xx = player.GetX() - x;
	float yy = player.GetY() - y - 32;
	float d2 = xx*xx + yy*yy;
	
	float apple_accel = 2500 * dt;
	
	if(valid) {
		if(d2 < RADIUS_OF_INFLUENCE*RADIUS_OF_INFLUENCE) {
			activated = true;
			chasePlayer = true;
			apple_accel *= d2 / (RADIUS_OF_INFLUENCE*RADIUS_OF_INFLUENCE);
		}
		if(d2 < 32*32) {
			player.GainItem(type);
			play_sample((SAMPLE*)data[S_01_APPLE + type].dat, 255, 127, 800 + rand()%401, FALSE);
			
			// now kill yourself.  the apple object, that is.
			return true;
		}
	}
	else {
		// Invalid objects have gravity acting on them
		dy += GRAVITY * dt;
	}
	
	
	// Activated apples are propelled toward the piggy
	if(activated) {
		//float d1 = 1250 * dt;
		//float d2 = 1600 * dt;
		float d1 = apple_accel;
		float d2 = apple_accel * 2;
		
		if(chasePlayer) {
			if(x > player.GetX()) {
				if(dx < 0.0) dx -= d1;
				else dx -= d2;
				
				if(dx < -MAX_APPLE_SPEED) dx = -MAX_APPLE_SPEED;
			}
			else {
				if(dx > 0.0) dx += d1;
				else dx += d2;
					
				if(dx > MAX_APPLE_SPEED) dx = MAX_APPLE_SPEED;
			}
				
			if(y > player.GetY()) {
				if(dy < 0.0) dy -= d1;
				else dy -= d2;
					
				if(dy < -MAX_APPLE_SPEED) dy = -MAX_APPLE_SPEED;
			}
			else {
				if(dy > 0.0) dy += d1;
				else dy += d2;
					
				if(dy > MAX_APPLE_SPEED) dy = MAX_APPLE_SPEED;
			}
		}
		else {
			// Kill items that are far from the player.
			if( fabs(x - player.GetX()) > SCREEN_W*3 || fabs(y - player.GetY()) > SCREEN_H*3)
				return true;
		}
		
		float ux = dx * dt;
		float uy = dy * dt;
		if(!isnan(ux) && !isinf(ux)) x += ux;
		if(!isnan(uy) && !isinf(uy)) y += uy;
		
	}
	
#endif
	return false;
}



void Apple::Draw(BITMAP *buffer, int cx, int cy) {
	BITMAP *apple = (BITMAP*)data[B_ITEM01_APPLE + type].dat;
	int aw2 = apple->w/2;
	int ah2 = apple->h/2;
	gl_draw_sprite_ex(B_ITEM01_APPLE + type, (int)x - cx - aw2, (int)y - cy - ah2);
}


