/*    Zonic the Hog.  A silly Sonic-like game written for Speedhack 2007
 *    Copyright (c) 2007 Steven Wallace / Chedda Cheeze
 *    email: steven.t.wallace @ gmail. com
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
 


#ifndef _LEVEL_H
#define _LEVEL_H


#define BLOCK_W	4
#define BLOCK_H	1


#include "Apple.h"
#include <vector>
#include <list>
#include "QuadMap.h"


using namespace std;

class Level {
public:
	Level();
	void Load(const char *filename);
	void Save(const char *filename);
	void Draw(struct BITMAP *buffer, int cx, int cy);


	void Plot(int x, int y, int type);
	void AddApple(int x, int y, int type);
	void AddBgItem(int x, int y, int type);
	void UpdateApples(float dt);
	void SpawnItem(int type, int x, int y);

	void ClearBgItems() { if(background) delete background; background = new QuadMap(100000,100000,0,0); }

	int GetHeight(int x) { return heightmap[x/BLOCK_W]*BLOCK_H; }
	int GetType(int x) { return typemap[x/BLOCK_W]; }
	int GetWidthInPixels() { return heightmap.size() * BLOCK_W; }

	
private:
	vector<int> heightmap;
	vector<int> typemap;
	QuadMap *background;
	list<Apple*> apples;
};



#endif // _LEVEL_H
