


// This provides an OpenGL compatibility layer to the game.
// We now draw with OpenGL instead of Allegro.  Hardware
// is always faster than software.  8-)
#ifndef _GL_COMPAT_H
#define _GL_COMPAT_H

#include <allegro.h>

void install_textures();
void gl_draw_sprite(struct BITMAP *dest, struct BITMAP *src, int x, int y);
void gl_draw_sprite_ex(int texid, int x, int y);
void gl_draw_sprite_v_flip(struct BITMAP *dest, struct BITMAP *src, int x, int y);

void gl_rectfill(struct BITMAP *dest, int x1, int y1, int x2, int y2, int col);
void gl_rect(struct BITMAP *dest, int x1, int y1, int x2, int y2, int col);
void gl_polygon(struct BITMAP *dest, int pts, int *data, int col);

void gl_pivot_sprite(struct BITMAP *dest, struct BITMAP *src, int x, int y, int cx, int cy, fixed angle);
void gl_pivot_sprite_ex(int tex_idx, int x, int y, int cx, int cy, float angleRad);
void gl_pivot_sprite_v_flip(struct BITMAP *dest, struct BITMAP *src, int x, int y, int cx, int cy, fixed angle);
void gl_pivot_sprite_h_flip(struct BITMAP *dest, struct BITMAP *src, int x, int y, int cx, int cy, fixed angle);
void gl_pivot_sprite_h_flip_ex(int tex_idx, int x, int y, int cx, int cy, float angle);


#endif // _GL_COMPAT_H

