/*    Zonic the Hog.  A silly Sonic-like game written for Speedhack 2007
 *    Copyright (c) 2007 Steven Wallace / Chedda Cheeze
 *    email: steven.t.wallace @ gmail. com
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License along
 *    with this program; if not, write to the Free Software Foundation, Inc.,
 *    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 
 
// Timer.h: interface for the Timer class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TIMER_H__C1606F45_E819_11DA_9D08_00D0594C1148__INCLUDED_)
#define AFX_TIMER_H__C1606F45_E819_11DA_9D08_00D0594C1148__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#include <allegro.h>
#ifdef WIN32
#include <winalleg.h>
#else
#include <unistd.h>
#include <sys/time.h>
#endif


class Timer  
{
public:
	Timer();
	virtual ~Timer();
	double TimeElapsed();

	void SetVariableRate();
	void SetConstRate(int fps);
	void FixConstRate();

private:
#ifdef WIN32
	LONGLONG pcFrequency;
	LONGLONG lastTime;
#else
	timeval lastTime;
#endif

	int refresh;			// Refresh rate of monitor
	double refresh1;		// Reciprocol of refresh rate

	// Specifies if we want a constant time between frames
	// or a variable time between frames.  Currently, variable
	// will eat up all your CPU time.
	// Defaults to variable
	enum { TIME_CONST, TIME_VARIABLE } mode;
	int targetFPS;
};

#endif // !defined(AFX_TIMER_H__C1606F45_E819_11DA_9D08_00D0594C1148__INCLUDED_)
