#include "Personagem.h"

Personagem::Personagem(CGameManager* _pManager):
	pManager(_pManager)
{}


void Personagem::Init(const char* fileName)
{
	LoadTextures(fileName);
	x = 1;
	y = 1;
	offset = 0;
	view = DIR_DOWN;
	move = DIR_DOWN;
	state = STATE_STAND;
	frameRate = 24;
}

void Personagem::Update()
{
	if (state == STATE_RUN)
	{
		offset++;
		if (offset == TILE_SIZE || offset == -TILE_SIZE)
		{
			offset = 0;
			state = STATE_STAND;

			switch(move)
			{
				case DIR_UP:
					y--;
					break;
				case DIR_DOWN:
					y++;
					break;
				case DIR_LEFT:
					x--;
					break;
				case DIR_RIGHT:
					x++;
					break;
			}
		}
	}
}

int Personagem::Move(Direcao dir)
{
	#define BORDA 1
	if (state == STATE_STAND)
	{
		move = dir;
		//view = dir;
		if (dir == DIR_UP && y <= BORDA || dir == DIR_DOWN && y >= 14-BORDA || dir == DIR_LEFT && x <= BORDA || dir == DIR_RIGHT && x >= 19-BORDA)
			return 0;
		state = STATE_RUN;
	}
	return 1;
}

void Personagem::Turn(Direcao dir)
{
	if (state == STATE_STAND)
		view = dir;
}

void Personagem::Clean()
{
	for (int linha = 0; linha < NUM_DIRECOES; linha++)
		for (int coluna = 0; coluna < NUM_FRAMES; coluna++)
		{
			destroy_bitmap(charset[linha][coluna]);
			charset[linha][coluna] = NULL;
		}
}

int Personagem::SetFrameRate(int fr)
{
	frameRate = fr;
}

void Personagem::Draw(BITMAP* activePage)
{
	switch(view)
	{
		case DIR_UP:
			draw_sprite(activePage, charset[view][(pManager->GetTimer() / frameRate) % NUM_FRAMES], x * TILE_SIZE + offsetBaseX, y * TILE_SIZE - offset + offsetBaseY);
			break;
		case DIR_DOWN:
			draw_sprite(activePage, charset[view][(pManager->GetTimer() / frameRate) % NUM_FRAMES], x * TILE_SIZE + offsetBaseX, y * TILE_SIZE + offset + offsetBaseY);
			break;
		case DIR_LEFT:
			draw_sprite(activePage, charset[view][(pManager->GetTimer() / frameRate) % NUM_FRAMES], x * TILE_SIZE - offset + offsetBaseX, y * TILE_SIZE + offsetBaseY);
			break;
		case DIR_RIGHT:
			draw_sprite(activePage, charset[view][(pManager->GetTimer() / frameRate) % NUM_FRAMES], x * TILE_SIZE + offset + offsetBaseX, y * TILE_SIZE + offsetBaseY);
			break;
	}
}

void Personagem::LoadTextures(const char* fileName)
{
    BITMAP* charsetTemp = load_bmp(fileName, NULL);
    tileWidth = charsetTemp->w / 4;
    tileHeight = charsetTemp->h / 4;
    for (int linha = 0; linha < NUM_DIRECOES; linha++)
		for (int coluna = 0; coluna < NUM_FRAMES; coluna++)
			charset[linha][coluna] = create_bitmap(tileWidth, tileHeight);

    offsetBaseX = (TILE_SIZE-tileWidth)/2;
    offsetBaseY = (TILE_SIZE-tileHeight);


	for (int linha = 0; linha < NUM_DIRECOES; linha++)
		for (int coluna = 0; coluna < NUM_FRAMES; coluna++)
            blit(charsetTemp, charset[linha][coluna], coluna * tileWidth, linha * tileHeight, 0, 0, tileWidth, tileHeight);

	destroy_bitmap(charsetTemp);
}

int Personagem::GetX()
{
	return x;
}

int Personagem::GetY()
{
	return y;
}

void Personagem::SetX(int _x)
{
	x = _x;
}

void Personagem::SetY(int _y)
{
	y = _y;
}
