#include "GameManager.h"
#include "GameIntroState.h"
#include "GameBattleState.h"
#include "GameBattleIntroState.h"
#include "GameStatsState.h"
#include "Heroi.h"
#include "Personagem.h"
#include "GameStateLevel01.h"

CGameStateLevel01 CGameStateLevel01::m_GameStateLevel01;

//! Default constructor
CGameStateLevel01::CGameStateLevel01(){}

//! Default destructor
CGameStateLevel01::~CGameStateLevel01(){}

//! Returns the game State
CGameStateLevel01* CGameStateLevel01::Instance()
{
	return ( &m_GameStateLevel01 );
}

//! Initialisation, loads data required for level.
void CGameStateLevel01::Init(CGameManager* pManager)
{
	//CGamePlayState::Init(pManager); // perform generic initialization from parent
	mapa = new h8or::Map;
	mapa->LoadMap("media/map1.xml");
	p = new Personagem(pManager);
	p->Init("media/014-Warrior02.bmp");
	p->SetX(10);
	p->SetY(7);
	pManager->ResetTimer();
	//pManager->heroi->SetHpMaximo(70);
	//pManager->heroi->SetHp(70);
}

//! Update, game loop for level, updates, moves and
//! displays all elements used by level
void CGameStateLevel01::Update(CGameManager * pManager)
{
	p->Update();
	mapa->Update();

	if ( (key[KEY_UP] || joy[0].stick[0].axis[1].d1
		|| key[KEY_DOWN] || joy[0].stick[0].axis[1].d2
		|| key[KEY_LEFT] || joy[0].stick[0].axis[0].d1
		|| key[KEY_RIGHT] || joy[0].stick[0].axis[0].d2	)
		&& (p->state == STATE_STAND && mapa->GetCurrentState() == STATE_STAND)
	   )
	{
		if (!(rand()%15)) // 1 a cada 15 passos, o jogador encontrar um monstro
			PushState(pManager, CGameBattleIntroState::Instance());
	}

	if (p->state == STATE_STAND)
	{
		if ( key[KEY_UP] || joy[0].stick[0].axis[1].d1 )
		{	p->Turn(DIR_UP);
			if (p->GetY() != 7)
				p->Move(DIR_UP);
			else
			{
				if (mapa->Move(DIR_UP))
					p->Move(DIR_UP);
			}
		}
		else
		{	if ( key[KEY_DOWN] || joy[0].stick[0].axis[1].d2 )
			{	p->Turn(DIR_DOWN);
				if (p->GetY() != 7)
					p->Move(DIR_DOWN);
				else
				{	if (mapa->Move(DIR_DOWN))
						p->Move(DIR_DOWN);
				}
			}
			else
			{	if ( key[KEY_LEFT] || joy[0].stick[0].axis[0].d1 )
				{	p->Turn(DIR_LEFT);
					if (p->GetX() != 10)
						p->Move(DIR_LEFT);
					else
					{	if (mapa->Move(DIR_LEFT))
							p->Move(DIR_LEFT);
					}
				}
				else
				{	if ( key[KEY_RIGHT] || joy[0].stick[0].axis[0].d2 )
					{	p->Turn(DIR_RIGHT);
						if (p->GetX() != 10)
							p->Move(DIR_RIGHT);
						else
						{	if (mapa->Move(DIR_RIGHT))
								p->Move(DIR_RIGHT);
						}
					}
				}
			}
		} // ELSE, if ( key[KEY_UP] || joy[0].stick[0].axis[1].d1 )
	} // if (p->state == STATE_STAND)

	if(key[KEY_R] || joy[0].button[7].b)
		pManager->heroi->SetHp(pManager->heroi->GetHpMaximo());
	if(key[KEY_SPACE] || joy[0].button[9].b)
		PushState(pManager, CGameStatsState::Instance());
	if(key[KEY_ESC])
		ChangeState(pManager, CGameIntroState::Instance()); // go back to introduction mode...
}


void CGameStateLevel01::Draw(CGameManager * pManager)
{
	mapa->Draw(pManager->activePage);// desenha este cenario na tela
	p->Draw(pManager->activePage);
	alfont_textout_aa_ex(pManager->activePage, pManager->font2, "Barra de Espao - informaes sobre o heri", 0, 480-44, 0, -1);
	alfont_textout_aa_ex(pManager->activePage, pManager->font2, "R - recupera vida", 0, 480-22, 0, -1);
}

//! Clears or destroys resources used by level, clean up.
void CGameStateLevel01::Clear(CGameManager* pManager)
{
	p->Clean();
	delete mapa;
}
