//////////////////////////////////////////////////////////////////////
/// GameState.h: interface for the CGameState class.
///
//////////////////////////////////////////////////////////////////////
#if !defined(AFX_GAMESTATE_H__AB04DC06_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_)
#define AFX_GAMESTATE_H__AB04DC06_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_

#include "GameManager.h"

class CGameState
{
public:
	virtual void Init(CGameManager* pManager) = 0;
	virtual void Clear(CGameManager* pManager) = 0;
	virtual void Update(CGameManager* pManager) = 0;
	virtual void Draw(CGameManager* pManager) = 0;

	virtual ~CGameState();

protected:
	CGameState();

	void ChangeState(CGameManager* pManager, CGameState* pState);
	void PushState(CGameManager* pManager, CGameState* pState);
	void PopState(CGameManager* pManager);

};

#endif


