#include "Game.h"
//#include "GamePlayState.h"
#include "GameIntroState.h"


//! Default constructor
CGameState::CGameState()
{}

//! Default destructor
CGameState::~CGameState()
{}

//! Overridden by subclass.
//! Change state, overridden by subclasses
void CGameState::ChangeState(CGameManager * pManager, CGameState * pState)
{
	pManager->ChangeState(pState);
}


void CGameState::PushState(CGameManager* pManager, CGameState* pState)
{
	pManager->PushState(pState);
}

void CGameState::PopState(CGameManager* pManager)
{
	pManager->PopState();
}

//! Implemented by subclass
//! Initialisation, loads data required for state.
void CGameState::Init(CGameManager * pManager)
{}

//! Implemented by subclass
//! Update, moves and renders screen.
void CGameState::Update(CGameManager * pManager)
{}

//! Implemented by subclass
//! Clear, tidy up
void CGameState::Clear(CGameManager* pManager)
{}

//! Implemented by subclass
//! Draw every thing on the buffer screen
void CGameState::Draw(CGameManager* pManager)
{}
