#include "GameBattleState.h"
#include "GameIntroState.h"
#include "GameBattleFinishState.h"
#include "Inimigo.h"
#include "Heroi.h"


CGameBattleState CGameBattleState::m_GameBattleState;

//! Default constructor
CGameBattleState::CGameBattleState(){}

//! Default destructor
CGameBattleState::~CGameBattleState(){}

CGameBattleState* CGameBattleState::Instance()
{
	return ( &m_GameBattleState );
}

void CGameBattleState::Init(CGameManager* pManager)
{
	backdrop = load_bmp("media/001-Grassland01.bmp", NULL);
	window = load_bmp("media/001-Blue01.bmp", NULL);

	if (!(backdrop && window))
	{
		allegro_message("No foi possil carregar as imagens da batalha.");
		exit(1);
	}
	turnoHeroi = true;
}

void CGameBattleState::Update(CGameManager* pManager)
{
	static int timerTecla = 0;
	if (!turnoHeroi)
	{	turnoHeroi = !turnoHeroi;
		danoRecebido = pManager->inimigo->FornecerDano();
		pManager->heroi->ReceberDano(danoRecebido);
	}
	else
	{	if (pManager->GetTimer() - timerTecla > 10)
		{	if (key[KEY_ENTER] || joy[0].button[0].b)
			{	turnoHeroi = !turnoHeroi;
				timerTecla = pManager->GetTimer();
				danoRecebido = pManager->heroi->FornecerDano();
				pManager->inimigo->ReceberDano(danoRecebido);
			}
		}
	}
	if (pManager->heroi->GetHp() < 1 || pManager->inimigo->GetHp() < 1)
		ChangeState(pManager, CGameBattleFinishState::Instance());
		//PopState(pManager);
}

void CGameBattleState::Draw(CGameManager* pManager)
{
	blit(backdrop, pManager->activePage, 0, 0, 0, 0, backdrop->w, backdrop->h);
	//rectfill(pManager->activePage, 0, 320, 639, 479, 0);
	stretch_blit(window, pManager->activePage, 0, 0, 128, 128, 5, 325, 630, 150);
	blit(window, pManager->activePage, 128, 0, 0, 320, 5, 5); // canto superior esquerdo
	blit(window, pManager->activePage, 128, 64-5, 0, 480-5, 5, 5); // canto inferior esquerdo
	blit(window, pManager->activePage, 128+64-5, 64-5, 640-5, 480-5, 5, 5); // canto inferior direito
	blit(window, pManager->activePage, 128+64-5, 0, 640-5, 320, 5, 5); // canto superior direito

	stretch_blit(window, pManager->activePage, 128+5, 0, 54, 5, 5, 320, 630, 5); // horizontal superior
	stretch_blit(window, pManager->activePage, 128+5, 64-5, 54, 5, 5, 480-5, 630, 5); // horizontal inferior
	stretch_blit(window, pManager->activePage, 128, 5, 5, 54, 0, 325, 5, 150); // horizontal inferior
	stretch_blit(window, pManager->activePage, window->w-5, 5, 5, 54, 640-5, 325, 5, 150); // horizontal inferior

	pManager->inimigo->Draw(pManager->activePage);
	pManager->heroi->Draw(pManager->activePage);
	alfont_textout_aa_ex(pManager->activePage, pManager->font2, "enter", 10, 480-32, makecol(255, 255, 255), -1);
	//alfont_textprintf_aa_ex(pManager->activePage, pManager->font2, 0, 0, makecol(255, 255, 255), 0, "dano = %2d", danoRecebido);
	//alfont_textout_aa_ex(pManager->activePage, pManager->font2, "Enter, para selecionar a opo (invisvel) de ataque", 0, 480-22, makecol(255, 255, 255), -1);
	//textprintf_ex(pManager->activePage, font, 0, 0, makecol(255, 255, 255), 0, "hp = %2d", pManager->heroi->GetHp());
	//textprintf_ex(pManager->activePage, font, 0, 8, makecol(255, 255, 255), 0, "hp = %2d", pManager->inimigo->GetHp());
	//textprintf_ex(pManager->activePage, font, 0, 16, makecol(255, 255, 255), 0, "dano = %2d", danoRecebido);
}

void CGameBattleState::Clear(CGameManager* pManager)
{
	destroy_bitmap(backdrop);
	destroy_bitmap(window);
	pManager->inimigo->Clear();
}
