#include "GameBattleIntroState.h"
#include "GameBattleState.h"
#include "Inimigo.h"
#include "Combatente.h"

CGameBattleIntroState CGameBattleIntroState::m_GameBattleIntroState;

//! Default constructor
CGameBattleIntroState::CGameBattleIntroState(){}

//! Default destructor
CGameBattleIntroState::~CGameBattleIntroState(){}

//! Singleton
CGameBattleIntroState* CGameBattleIntroState::Instance()
{
	return ( &m_GameBattleIntroState );
}

//! Initialize stuff
void CGameBattleIntroState::Init(CGameManager* pManager)
{
	lastImage = create_bitmap(640, 480);
	blit(screen, lastImage, 0, 0, 0, 0, 640, 480);
	iteracao = 0;

	pManager->inimigo->Init("", rand()%22); /// \todo Modificar o numero randomico, pela distancia do heroi at sua casa.
}

void CGameBattleIntroState::Update(CGameManager* pManager)
{
	iteracao += 2;
	if (iteracao > 255)
		ChangeState(pManager, CGameBattleState::Instance());
}

void CGameBattleIntroState::Draw(CGameManager* pManager)
{
	clear_to_color(pManager->activePage, 0);
	set_trans_blender(0, 0, 0, 255-iteracao);
	draw_trans_sprite(pManager->activePage, lastImage, 0, 0);
}

void CGameBattleIntroState::Clear(CGameManager* pManager)
{
	destroy_bitmap(lastImage);
}
