#include "GameBattleFinishState.h"
#include "Heroi.h"
#include "Inimigo.h"

CGameBattleFinishState CGameBattleFinishState::m_GameBattleFinishState;

//! Default constructor
CGameBattleFinishState::CGameBattleFinishState(){}

//! Default destructor
CGameBattleFinishState::~CGameBattleFinishState(){}

//! Singleton
CGameBattleFinishState* CGameBattleFinishState::Instance()
{
	return ( &m_GameBattleFinishState );
}

//! Initialize stuff
void CGameBattleFinishState::Init(CGameManager* pManager)
{
	atualizouXP = aumentouLevel = false;
}

void CGameBattleFinishState::Update(CGameManager* pManager)
{
	venceu = pManager->heroi->GetHp() > 0;
	if (!atualizouXP && venceu)
	{	aumentouLevel = pManager->heroi->AumentaXP(pManager->inimigo->xp);
		atualizouXP = true;
	}
	if (key[KEY_ESC])
		PopState(pManager);
		//ChangeState(pManager, CGameStateLevel01::Instance());
}

void CGameBattleFinishState::Draw(CGameManager* pManager)
{
	clear_to_color(pManager->activePage, 0);
	if (aumentouLevel)
		alfont_textout_aa_ex(pManager->activePage, pManager->font2, "AEEEE!! AUMENTOU LEVEL!!!!", 0, 0, makecol(255, 255, 255), -1);
	if (venceu)
		alfont_textprintf_aa_ex(pManager->activePage, pManager->font2, 0, 90, makecol(255, 255, 255), -1, "ganhou %d XP", pManager->inimigo->xp);
	else
		alfont_textout_aa_ex(pManager->activePage, pManager->font2, "Perdeu a batalha", 0, 0, makecol(255, 255, 255), -1);
	alfont_textout_aa_ex(pManager->activePage, pManager->font2, "esc (press and release fast)", 0, 480-22, makecol(255, 255, 255), -1);
}

void CGameBattleFinishState::Clear(CGameManager* pManager)
{
}
