#ifndef PERSONAGEM_H_INCLUDED
#define PERSONAGEM_H_INCLUDED

#include "GameManager.h"
#include <allegro.h>
#include "enum_types.h"

#define NUM_DIRECOES	4
#define NUM_FRAMES		4
#define TILE_SIZE		32
#define FRAME_RATE      34

//! \class Personagem
class Personagem
{
public:
	Personagem(CGameManager* _pManager);

	void Init(const char*);
	void Update();
	void Draw(BITMAP*);
	void Clean();

	int Move(Direcao dir);
	void Turn(Direcao dir);

	int GetX();
	int GetY();
	void SetX(int);
	void SetY(int);
	State state;
	int SetFrameRate(int fr);

private:
	BITMAP* charset[NUM_DIRECOES][NUM_FRAMES];
	int tileWidth;
	int tileHeight;
	int offsetBaseX;
	int offsetBaseY;
	int x, y;
	int offset;
	CGameManager* pManager;
	Direcao view;
	Direcao move;
	int frameRate;

	void LoadTextures(const char*);
};

#endif // PERSONAGEM_H_INCLUDED
