#ifndef H8OR_MAP
#define H8OR_MAP

#include <allegro.h>
#include <tinyxml.h>
#include <string>
#include "enum_types.h"


using namespace std;

namespace h8or
{
#define TILE_SIZE 32
#define AUTOTILE_NUM 16

/*! \class Map
 * Autotile do RPG Maker
 * \author H8OR
 * \date 2007-01-26-12.18
 */
class Map
{
public:
	Map();
	~Map();
	void Update();
	int LoadMap(const char*);
	void Draw(BITMAP*);
	int LoadAutoTile(const char*);
	void SetVisible(int, int);
	int Move(Direcao);

	State GetCurrentState();

protected:
	State state;
	int offset;
	Direcao direcao;
	int **matriz;
	int numTiles;
	int heightTiles;
	int widthTiles;
	int heightPixels;
	int widthPixels;
	BITMAP *autotile[AUTOTILE_NUM + 1];
	BITMAP *tileset;
	int tilesetWidth;

	BITMAP *autotileCSE[5];
	BITMAP *autotileCSD[5];
	BITMAP *autotileCIE[5];
	BITMAP *autotileCID[5];
	BITMAP *floor;

	BITMAP *screen2;

	int visibleX1;		/* Top left Corner of the Currently visible portion */
	int visibleY1;		/* of the tile map (in pixels)                      */
	int visibleX2;		/* Bottom right Corner                              */
	int visibleY2;


	int CalculaIndice(int, int, int);

}; // class Map

} // namespace h8or

#endif // H8OR_MAP
