#include <allegro.h>
#include "Combatente.h"
#include "GameManager.h"
#include "Inimigo.h"

void CInimigo::Init(const char* fileName, double distancia)
{
	if (distancia < 10)
	{	hpMaximo = rand() % 6 + 7;
		hpAtual = hpMaximo;
		forca = rand()%6 + 5;
		imagem = load_bitmap("media/087-Monster01.bmp", NULL);
		xp = 1;
	}
	else
	{	if (distancia < 20)
		{	hpMaximo = rand()%10 + 10;
			hpAtual = hpMaximo;
			forca = rand()%6 + 9;
			imagem = load_bitmap("media/091-Monster05.bmp", NULL);
			xp = 5;
		}
		else
		{	hpMaximo = rand() % 15 + 15;
			hpAtual = hpMaximo;
			forca = rand()%6 + 13;
			imagem = load_bitmap("media/049-Soldier01.bmp", NULL);
			xp = 10;
		}
	}
	if (!imagem)
	{	allegro_message("Erro, no foi possvel carregar a imagem do inimigo.");
		exit(1);
	}
	// carrega do XML as caracteristicas do inimigo e inicializa
}

void CInimigo::Clear()
{
	destroy_bitmap(imagem);
}

void CInimigo::Draw(BITMAP* activePage)
{
	draw_sprite(activePage, imagem, 160-imagem->w/2, 160 - imagem->h/2);
	int inicioBarraX = 160-hpMaximo/2;
	int inicioBarraY = 160+imagem->h/2;
	rectfill(activePage, inicioBarraX, inicioBarraY, inicioBarraX + hpMaximo, inicioBarraY+16, makecol(255, 255, 0));
	rectfill(activePage, inicioBarraX + hpAtual, inicioBarraY, inicioBarraX + hpMaximo, inicioBarraY+16, makecol(255, 0, 0));
}

void CInimigo::Update()
{
}
