#include <allegro.h>
#include "Combatente.h"
#include "Heroi.h"

CHeroi::~CHeroi()
{}

void CHeroi::Init()
{
	xpAtual = 0;
	xpNext = 20;

	hpMaximo = 70;
	hpAtual = 70;

	forca = 5;
	arma = 3;
	evade = 8;

	imagem = load_bitmap("media/heroi.bmp", NULL);
	if (!imagem)
	{	allegro_message("Erro: no foi possivel carregar a imagem do heri.");
		exit(1);
	}
}

void CHeroi::Clear()
{
	destroy_bitmap(imagem);
}

void CHeroi::Draw(BITMAP* activePage)
{
	draw_sprite(activePage, imagem, 480 - imagem->w/2, 160-imagem->h/2);
	const int inicioBarraX = 480-hpMaximo/2;
	const int inicioBarraY = 160+imagem->h/2;
	rectfill(activePage, inicioBarraX, inicioBarraY, inicioBarraX + hpMaximo, inicioBarraY+16, makecol(255, 255, 0));
	rectfill(activePage, inicioBarraX + hpAtual, inicioBarraY, inicioBarraX + hpMaximo, inicioBarraY+16, makecol(255, 0, 0));
}

void CHeroi::Update()
{}

int CHeroi::GetForca()
{
	return forca + arma;
}

bool CHeroi::AumentaXP(int xp)
{
	xpAtual += xp;
	if (xpAtual >= xpNext)
	{
		level++;
		hpMaximo += (double)hpMaximo * 0.1;
		forca += (double)forca * 0.1 + 2;
		xpNext = xpNext * 2;
		// aumenta fora
		// aumenta vida
		// aumenta defesa
		return true;
	}
	return false;
}

int CHeroi::GetXpAtual()
{
	return xpAtual;
}

int CHeroi::GetXpNext()
{
	return xpNext;
}
