#include "GameStatsState.h"
#include "Heroi.h"

CGameStatsState CGameStatsState::m_GameBattleIntroState;

//! Default constructor
CGameStatsState::CGameStatsState(){}

//! Default destructor
CGameStatsState::~CGameStatsState(){}

//! Singleton
CGameStatsState* CGameStatsState::Instance()
{
	return ( &m_GameBattleIntroState );
}

//! Initialize stuff
void CGameStatsState::Init(CGameManager* pManager)
{
	window = load_bitmap("media/001-Blue01.bmp", NULL);
}

void CGameStatsState::Update(CGameManager* pManager)
{
	if (key[KEY_ESC] || joy[0].button[9].b)
		PopState(pManager);
}

void CGameStatsState::Draw(CGameManager* pManager)
{
	#define INICIO_HP_X 70
	#define INICIO_HP_Y 32
	#define INICIO_PWR_X 70
	#define INICIO_PWR_Y 64
	#define INICIO_XP_X 70
	#define INICIO_XP_Y 96
	//clear_to_color(pManager->activePage, 0);
	stretch_blit(window, pManager->activePage, 0, 0, 128, 128, 0, 0, SCREEN_W, SCREEN_H);
	alfont_textout_aa_ex(pManager->activePage, pManager->font2, "esc", 0, 480-22, makecol(255, 255, 255), -1);
	alfont_textout_aa_ex(pManager->activePage, pManager->font2, "Heroi", 0, 0, makecol(255, 255, 255), -1);

	// Health Points
	alfont_textout_aa_ex(pManager->activePage, pManager->font2, "HP", 0, 30, makecol(255, 255, 255), -1);
	rectfill(pManager->activePage, INICIO_HP_X, INICIO_HP_Y, INICIO_HP_X + pManager->heroi->GetHpMaximo(), INICIO_HP_Y+16, makecol(255, 255, 0));
	rectfill(pManager->activePage, INICIO_HP_X + pManager->heroi->GetHp(), INICIO_HP_Y, INICIO_HP_X + pManager->heroi->GetHpMaximo(), INICIO_HP_Y+16, makecol(255, 0, 0));

	// Power
	alfont_textout_aa_ex(pManager->activePage, pManager->font2, "PWR", 0, 60, makecol(255, 255, 255), -1);
	rectfill(pManager->activePage, INICIO_PWR_X, INICIO_PWR_Y, INICIO_PWR_X + pManager->heroi->GetForca(), INICIO_PWR_Y+16, makecol(0, 0, 255));

	alfont_textout_aa_ex(pManager->activePage, pManager->font2, "XP", 0, 90, makecol(255, 255, 255), -1);
	rectfill(pManager->activePage, INICIO_XP_X, INICIO_XP_Y, INICIO_XP_X + pManager->heroi->GetXpNext(), INICIO_XP_Y+16, makecol(0, 0, 255));
	rectfill(pManager->activePage, INICIO_XP_X + pManager->heroi->GetXpAtual(), INICIO_XP_Y, INICIO_XP_X + pManager->heroi->GetXpNext(), INICIO_XP_Y+16, makecol(0, 255, 64));


	alfont_textprintf_aa_ex(pManager->activePage, pManager->font2, 0, 120, makecol(255, 255, 255), -1, "Tempo: %02d:%02d:%02d", pManager->GetTimer()/96/60/60, pManager->GetTimer()/96/60, (pManager->GetTimer()/96)%60);

	//set_trans_blender(0, 0, 0, 255-iteracao);
	//draw_trans_sprite(pManager->activePage, lastImage, 0, 0);
}

void CGameStatsState::Clear(CGameManager* pManager)
{
	destroy_bitmap(window);
}
