//////////////////////////////////////////////////////////////////////
/// GameManager.h: interface for the CGameManager class.
///
//////////////////////////////////////////////////////////////////////
#if !defined(AFX_GAMEMANAGER_H__AB04DC05_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_)
#define AFX_GAMEMANAGER_H__AB04DC05_BB05_11D4_87CB_00C04F73BBBB__INCLUDED_

#include <allegro.h>
#include <alfont.h>
#include <audiere.h>
using namespace audiere;

class CGameState;
class CCombatente;
class CInimigo;
class CHeroi;

class CGameManager
{
public:
	bool gameOver;
	ALFONT_FONT *font1; //!< fonte usada no menu
	ALFONT_FONT *font2; //!< Microsoft Sans Serif
	BITMAP* activePage;
	CInimigo* inimigo;
	CHeroi* heroi;

	volatile int GetSpeedCounter();
	void DecrementSpeedCounter();
	volatile int GetTimer();
	void ResetTimer();

	void Update();
	void Draw();
	CGameManager();
	virtual ~CGameManager();
	void PushState(CGameState* pState);
	void PopState();

	AudioDevicePtr device;
	OutputStreamPtr menuSound;

private:
	BITMAP* page1;
	BITMAP* page2;

	void ChangeState(CGameState* pState);
	void CreateDevice();
	void Init();
	friend class CGameState;
	CGameState* m_pGameState;
	CGameState* m_pGameStateStack;

};
#endif
