#include <allegro.h>
#include <alfont.h>
#include "Inimigo.h"
#include "Heroi.h"
#include "GameState.h"
#include "GameManager.h"
#include "GameIntroState.h"


volatile int g_speedCounter = 0;
volatile int g_timer = 0;


//! Incrementa o controlador de tempo.
void IncrementSpeedCounter()
{
	g_speedCounter++;
	g_timer++;
}


//! Default constructor
CGameManager::CGameManager():
	gameOver(false),
	m_pGameStateStack(NULL)
{
	CreateDevice();  // Inicializa a Allegro e os recursos que sero utilizados.
	m_pGameState = 0;
	ChangeState( CGameIntroState::Instance() );

}

//! Default destructor
CGameManager::~CGameManager()
{
	delete inimigo;
	delete heroi;
}

//! Changes the game state, calls the existing states Clear
//! function before the next states Init function
void CGameManager::ChangeState(CGameState * pState)
{
	if (m_pGameState)
		m_pGameState->Clear(this);
	if ( pState != m_pGameState )
	{
		m_pGameState = pState;
		m_pGameState->Init(this);
	}
	rest(150);
}

//! Holds a pointer to the current states, (level) Update function
//! The Update will be the game loop for the current state
void CGameManager::Update()
{
	poll_joystick();
	if (key[KEY_A] && key[KEY_S] && key[KEY_D] && key[KEY_F]) // meu teclado no t funcionanodo direito, o ESC nao funciona
		exit(1);
	m_pGameState->Update(this);
}

//! \brief Desenha na tela as coisas.
void CGameManager::Draw()
{
	m_pGameState->Draw(this);
	show_video_bitmap(activePage);
    activePage = (activePage == page1 ? page2 : page1);
}

/*! Inicializa a biblioteca Allegro.
 * Prepara o hardware: teclado, joystick, timer e tambm instala a alfont.
 */
void CGameManager::CreateDevice()
{
	srand(time(NULL));
	allegro_init();
	set_uformat(U_ASCII);
	set_color_depth(32);
	if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0) != 0)
	{	allegro_message("No foi possvel iniciar o modo grfico.");
		return;
	}
	page1 = create_video_bitmap(SCREEN_W, SCREEN_H); // Page Flip
    page2 = create_video_bitmap(SCREEN_W, SCREEN_H);
    activePage = page2;
	install_timer();
	install_keyboard();
	install_joystick(JOY_TYPE_AUTODETECT);
	alfont_init();
	Init();
	// Audiere
	device = OpenDevice();
	menuSound = OpenSound(device, "media/Guns - Don't You Cry - parte 1.mp3", true);
}

/*! Game manager general Initialization function. Also initialise or
 * load each of the plugable managers
 */
void CGameManager::Init()
{
	LOCK_VARIABLE(g_speedCounter);
	LOCK_VARIABLE(g_timer);
    LOCK_FUNCTION(IncrementSpeedCounter);
    install_int_ex(IncrementSpeedCounter, BPS_TO_TIMER(96));
    // load fonts for use with alfont
    font1 = alfont_load_font("media/battlelines.ttf");
	alfont_set_font_size(font1, 40);
	font2 = alfont_load_font("media/micross.ttf");
	alfont_set_font_size(font2, 22);


	heroi = new CHeroi();
	heroi->Init();
	inimigo = new CInimigo();

}

volatile int CGameManager::GetSpeedCounter()
{
	return g_speedCounter;
}

void CGameManager::DecrementSpeedCounter()
{
	g_speedCounter--;
}

volatile int CGameManager::GetTimer()
{
	return g_timer;
}

void CGameManager::PushState(CGameState* pState)
{
	if (m_pGameStateStack)
		m_pGameStateStack->Clear(this);
	m_pGameStateStack = m_pGameState;
	m_pGameState = pState;
	m_pGameState->Init(this);
	rest(150);

}

void CGameManager::PopState()
{
	if (m_pGameState)
		m_pGameState->Clear(this);
	m_pGameState = m_pGameStateStack;
	m_pGameStateStack = NULL;
	rest(150);
}

void CGameManager::ResetTimer()
{
	g_timer = 0;
}
