#include "GameManager.h"
#include "GameStateLevel01.h"
#include "GameIntroState.h"

CGameIntroState CGameIntroState::m_IntroductionState;

//! \brief Default constructor
CGameIntroState::CGameIntroState():
	foco(0)
{
	itens[0] = "Play";
	itens[1] = "Continue";
	itens[2] = "Creditos";
	itens[3] = "Exit";
}

//! \brief Default destructor
CGameIntroState::~CGameIntroState()
{}


CGameIntroState* CGameIntroState::Instance()
{
	return ( &m_IntroductionState );
}

void CGameIntroState::Init(CGameManager * pManager)
{
	m_titlePic = load_bmp("media/titulo.bmp", NULL);
	pManager->menuSound->reset();
	pManager->menuSound->setVolume(1.0f);
	#ifndef H8OR_DEBUG_MODE
	pManager->menuSound->play();
	#endif
}

void CGameIntroState::Update(CGameManager * pManager)
{
	static int lastTime = 0;

	if (key[KEY_ESC])
		pManager->gameOver = true;

	if (pManager->GetTimer() - lastTime > 10)
	{	if ((key[KEY_UP] || joy[0].stick[0].axis[1].d1) && foco > 0)
		{	foco--;
			lastTime = pManager->GetTimer();
		}
		if ((key[KEY_DOWN] || joy[0].stick[0].axis[1].d2) && foco < 3)
		{	foco++;
			lastTime = pManager->GetTimer();
		}
	}
	if (key[KEY_ENTER] || key[KEY_ENTER_PAD] || key[KEY_SPACE] || joy[0].button[0].b)
	{	switch(foco)
		{
			case 0:
				ChangeState(pManager, CGameStateLevel01::Instance());
				break;

			case 3:
				pManager->gameOver = true;
				break;
		}
	}
}

void CGameIntroState::Clear(CGameManager * pManager)
{
	destroy_bitmap(m_titlePic);
	pManager->menuSound->stop();
}

//! Desenha tudo no buffer do GameManager.
void CGameIntroState::Draw(CGameManager* pManager)
{
	blit(m_titlePic, pManager->activePage, 0, 0, 0, 0, m_titlePic->w, m_titlePic->h);
	#define ALTURA 200
	#define MENU_FONT_SIZE 40
	static int colorFocusOn = makecol(251, 172, 25);
	static int colorFocusOff = makecol(64, 64, 64);
	rectfill(pManager->activePage, 240, ALTURA + foco * 40, 400, ALTURA + foco * 40 + 40, 0);
	for (int i = 0; i < 4; i++)
		alfont_textout_centre_aa_ex(pManager->activePage, pManager->font1, itens[i],     pManager->activePage->w / 2, ALTURA + MENU_FONT_SIZE * i, (foco == i ? colorFocusOn : colorFocusOff), -1);
}
