#ifndef H8OR_ROOM
#define H8OR_ROOM

#include <allegro.h>
#include "map.h"
#include <string>

#define NUMBER_TILES  5


/*! Enumeration for player direction.
 */
enum E_PLAYER_DIRECTION
{
    EPD_DOWN = 0,
    EPD_LEFT,
    EPD_RIGHT,
    EPD_UP
};


/*! \class CRoom
 * \brief Especializao da CMap. Responsvel por desenhar o cenrio.
 * \date 2007-09-30-01.37
 */
class CRoom : public CMap
{
protected:
	CMap* mapaOriginal;
    BITMAP *tileset[NUMBER_TILES];
    bool drawFirstTime;

    void DrawSquare(int row, int col, BITMAP* buffer);

	int row;
    int col;
    int offset;
    int direcao;
    int state;

public:
    static std::string tilesetName;
	static std::string charsetName;

	CRoom(CMap*);
    ~CRoom();
    void Draw(BITMAP* buffer, int pRow, int pCol);
    bool IsWinner();
    void Load();
    void Push(int rowPush, int colPush, int direcaoPush);
    void UpdateLogic();
};

#endif //H8OR_ROOM
