/*! \file room.cpp
 * \date 2007-09-30-01.41
 * \todo Substituir os defines por enums.
 */


#include "room.h"

std::string CRoom::tilesetName;
std::string CRoom::charsetName;


#define DIR_DOWN	0
#define DIR_LEFT	1
#define DIR_RIGHT	2
#define DIR_UP		3

#define STATE_STOP   0
#define STATE_MOVING 1

#define I_FLOOR       0
#define I_WALL        1
#define I_SKULL       2
#define I_BOX         3
#define I_SKULL_BOX   4

#define TL_FLOOR      0
#define TL_WALL       1
#define TL_SKULL      2
#define TL_BOX        4
#define TL_SKULL_BOX  6


#define TILE_SIZE    32

/*! Inicializa as variveis, carrega imagens...
 */
CRoom::CRoom(CMap* mapa):
    drawFirstTime(true),
    mapaOriginal(mapa)
{
    numRows = mapa->numRows;
    numCols = mapa->numCols;
	playerRow = mapa->playerRow;
	playerCol = mapa->playerCol;
//	tilesetName = "res/tileset.bmp";
//	charsetName = "res/079-angel.bmp";

	BITMAP *imagem = load_bmp(tilesetName.c_str(), NULL);
	for (int i = 0; i < NUMBER_TILES; i++)
	{
		tileset[i] = create_bitmap(TILE_SIZE, TILE_SIZE);
		blit(imagem, tileset[i], i * TILE_SIZE, 0, 0, 0, TILE_SIZE, TILE_SIZE);
	}
	destroy_bitmap(imagem);

    // Parece que o construtor de CMap no est sendo chamado. Portanto...
	matrix = new int* [numRows];
	for (int row = 0; row < numRows; row++)
		matrix[row] = new int [numCols];

	Load();
}


CRoom::~CRoom()
{
	for (int i = 0; i < NUMBER_TILES; i++)
		destroy_bitmap(tileset[i]);
	// no precisa deletar a matriz porque o destrutor de CMap j faz isso.
}

void CRoom::Load()
{
    drawFirstTime = true;
	state = STATE_STOP;
	for (int linha = 0; linha < numRows; linha++)
		for (int coluna = 0; coluna < numCols; coluna++)
			matrix[linha][coluna] = mapaOriginal->matrix[linha][coluna];
}

void CRoom::DrawSquare(int iRow, int iCol, BITMAP* buffer)
{
    for (int row = iRow -1; row <= iRow+1 ; row++)
    {
        for (int col = iCol-1; col <= iCol+1 ; col++)
        {
            if (row >= numRows || row < 0 || col >= numCols || col < 0)
                continue;
            if (matrix[row][col] == TL_WALL)
                draw_sprite(buffer, tileset[I_WALL], col * TILE_SIZE, row * TILE_SIZE);
            else
                draw_sprite(buffer, tileset[I_FLOOR], col * TILE_SIZE, row * TILE_SIZE);
            if (matrix[row][col] == TL_SKULL_BOX)
                draw_sprite(buffer, tileset[I_SKULL_BOX], col * TILE_SIZE, row * TILE_SIZE);
            else
            {
                if (matrix[row][col] & 2)
                    draw_sprite(buffer, tileset[I_SKULL], col * TILE_SIZE, row * TILE_SIZE);
                if (matrix[row][col] & 4)
                    draw_sprite(buffer, tileset[I_BOX], col * TILE_SIZE, row * TILE_SIZE);
            }
        }
    }
}

void CRoom::Draw(BITMAP* buffer, int pRow, int pCol)
{
    if (drawFirstTime)
    {
        drawFirstTime = false;
        for (int row = 0; row < numRows; row++)
        {
            for (int col = 0; col < numCols; col++)
            {
                if (matrix[row][col] == TL_WALL)
                    draw_sprite(buffer, tileset[I_WALL], col * TILE_SIZE, row * TILE_SIZE);
                else
                    draw_sprite(buffer, tileset[I_FLOOR], col * TILE_SIZE, row * TILE_SIZE);
                if (matrix[row][col] == TL_SKULL_BOX)
                    draw_sprite(buffer, tileset[I_SKULL_BOX], col * TILE_SIZE, row * TILE_SIZE);
                else
                {
                    if (matrix[row][col] & 2)
                        draw_sprite(buffer, tileset[I_SKULL], col * TILE_SIZE, row * TILE_SIZE);
                    if (matrix[row][col] & 4)
                        draw_sprite(buffer, tileset[I_BOX], col * TILE_SIZE, row * TILE_SIZE);
                }
            }
        }
    }
    else
    {
        DrawSquare(pRow, pCol, buffer);
    }

	if (state == STATE_MOVING)
	{
	    //DrawSquare(row, col, buffer);
		switch (direcao)
		{
		case DIR_UP:
			draw_sprite(buffer, tileset[I_BOX], col*TILE_SIZE, row*TILE_SIZE-offset);
			break;
		case DIR_DOWN:
			draw_sprite(buffer, tileset[I_BOX], col*TILE_SIZE, row*TILE_SIZE+offset);
			break;
		case DIR_LEFT:
			draw_sprite(buffer, tileset[I_BOX], col*TILE_SIZE-offset, row*TILE_SIZE);
			break;
		case DIR_RIGHT:
			draw_sprite(buffer, tileset[I_BOX], col*TILE_SIZE+offset, row*TILE_SIZE);
			break;
		}
	}

}

bool CRoom::IsWinner()
{
	for (int row = 0; row < numRows; row++)
		for (int col = 0; col < numCols; col++)
			if (matrix[row][col] == 2)
				return false;
	return true;
}

void CRoom::Push(int rowPush, int colPush, int direcaoPush)
{
	state = STATE_MOVING;
	direcao = direcaoPush;
	row = rowPush;
	col = colPush;
	offset = 0;
	matrix[row][col] &= ~TL_BOX; // apagar a caixa
}

void CRoom::UpdateLogic()
{
	if (state == STATE_MOVING)
	{
		offset++;
		if (offset >= 32)
		{
			// colocar a caixa na nova posio
			switch (direcao)
			{
			case EPD_UP:
				matrix[row-1][col] |= TL_BOX;
				break;
			case EPD_DOWN:
				matrix[row+1][col] |= TL_BOX;
				break;
			case EPD_LEFT:
				matrix[row][col-1] |= TL_BOX;
				break;
			case EPD_RIGHT:
				matrix[row][col+1] |= TL_BOX;
				break;
			}
			state = STATE_STOP;
			offset = 0;
		}
	}
}
