#ifndef H8OR_OPTIONS
#define H8OR_OPTIONS

#include <allegro.h>
#include <tinyXml.h>
#include <string>
#define XML_FILE "config.xml"

class COptions
{
public:
	COptions();
	~COptions();

	int isWindowed;
	int color_depth;
	int screen_w;
	int screen_h;


	void LoadXML();
	void SaveXML();

	void SetLastLevel(int);
	int GetLastLevel();

	std::string GetCharset();
	void SetCharset(const char* charsetName);

	std::string GetTileset();
	void SetTileset(const char* tilesetName);

	std::string GetFilename();
	void SetFilename(const char* newFileName);

protected:
	TiXmlDocument *doc;
	TiXmlElement *elementGraphics;
	TiXmlElement *elementLastLevel;
	TiXmlElement *elementCharset;
	TiXmlElement *elementTileset;
	TiXmlElement *elementFilename;

	std::string fileName;
	std::string charset;
	std::string tileset;
	int lastLevel;

};

#endif // H8OR_OPTIONS
