#include "options.h"

COptions::COptions()
{
	LoadXML();
}

COptions::~COptions()
{
	SaveXML();
}

void COptions::LoadXML()
{

    doc = new TiXmlDocument(XML_FILE);
    if (!doc->LoadFile())
    {
        allegro_message("Erro na abertura do documento");
        exit(1);
    }

    TiXmlNode *raiz = doc->RootElement();
    TiXmlElement *rootElement = raiz->ToElement();

	elementGraphics = rootElement->FirstChildElement("graphics");
	elementGraphics->Attribute("width", &screen_w);
	elementGraphics->Attribute("height", &screen_h);
	elementGraphics->Attribute("color_depth", &color_depth);
	elementGraphics->Attribute("windowed", &isWindowed);

    elementLastLevel = rootElement->FirstChildElement("lastlevel");
	elementLastLevel->Attribute("value", &lastLevel);

	elementCharset = rootElement->FirstChildElement("charset");
	charset = elementCharset->Attribute("src");

	elementTileset = rootElement->FirstChildElement("tileset");
	tileset = elementTileset->Attribute("src");

	elementFilename = rootElement->FirstChildElement("filename");
	fileName = elementFilename->Attribute("src");

}


/*! \brief Grava as informaes no arquivo ini.
 * Tem que gravar todas as variaveis e no apenas as que foram modificadas,
 * porque se no, o arquivo conter apenas as variveis que foram
 * modificadas e no todas.
 */
void COptions::SaveXML()
{
	elementLastLevel->SetAttribute("value", lastLevel);
	//elementCharset->SetAttribute("src", charset.c_str());
	//elementTileset->SetAttribute("src", tileset.c_str());
	//elementFilename->SetAttribute("src", fileName.c_str());
	doc->SaveFile(XML_FILE);
}


/*! \brief Salva o ltimo arquivo no resolvido.  */
void COptions::SetLastLevel(int newLastLevel)
{
	if (newLastLevel > lastLevel)
		lastLevel = newLastLevel;
}

/*! \brief Retorna o ltimo arquivo no resolvido. */
int COptions::GetLastLevel()
{
	return lastLevel;
}

std::string COptions::GetCharset()
{
    return charset;
}

void COptions::SetCharset(const char* charsetName)
{
    charset = charsetName;
}

std::string COptions::GetTileset()
{
    return tileset;
}

void COptions::SetTileset(const char* tilesetName)
{
    tileset = tilesetName;
}

std::string COptions::GetFilename()
{
    return fileName;
}

void COptions::SetFilename(const char* newFileName)
{
    fileName = newFileName;
}
