#include "menu.h"

CMenu::CMenu(COptions* newOptions)
{
	options = newOptions;
	allegro_init();
	set_color_depth(options->color_depth);
    if (set_gfx_mode((options->isWindowed ? GFX_AUTODETECT_WINDOWED : GFX_AUTODETECT_FULLSCREEN), options->screen_w, options->screen_h, 0, 0))
    {
        allegro_message("Erro ao iniciar modo grafico");
        allegro_message("width = %d\nheight = %d\nwindowed = %d\ncolor_depth = %d", options->screen_w, options->screen_h, options->isWindowed, options->color_depth);
        allegro_exit();
        exit(1);
    }

	alfont_init();
	install_timer();
	install_keyboard();
	install_joystick(JOY_TYPE_AUTODETECT);

	titulo = load_bmp(IMAGEM_TITULO, NULL);
	fontMenu = alfont_load_font(MENU_FONT_NAME);
	alfont_set_font_size(fontMenu, MENU_FONT_SIZE);
	foco = 0;
	colorFocusOn = makecol(254, 224, 14);
	colorFocusOff = makecol(255, 255, 255);
	gkernel = new CGKernel(options);
}


CMenu::~CMenu()
{
	destroy_bitmap(titulo);
    alfont_destroy_font(fontMenu);
    delete gkernel;
	clear_keybuf();
	alfont_exit();
	allegro_exit();
}

void CMenu::Go()
{
    BITMAP* buffer	 = create_bitmap(SCREEN_W, SCREEN_H);
	bool sair = false;
	bool precisaAtualizar = true;
	while(!sair)
	{
	    poll_joystick();
        if ((key[KEY_UP] || joy[0].stick[0].axis[1].d1) && foco > 0)
        {
            precisaAtualizar = true;
            foco--;
        }
        if ((key[KEY_DOWN] || joy[0].stick[0].axis[1].d2) && foco < NUM_OPCOES - 1)
        {
            precisaAtualizar = true;
            foco++;
        }
        if (key[KEY_ENTER] || key[KEY_ENTER_PAD] || joy[0].button[0].b)
        {
            switch(foco)
            {
                case 0: // Play
                    gkernel->Go(0);
                    blit(titulo, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
                    precisaAtualizar = true;
                    break;

                case 1: // Continue
					gkernel->Go(options->GetLastLevel());
                    blit(titulo, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
                    precisaAtualizar = true;
                    break;

				case 2:
                    Credits();
                    precisaAtualizar = true;
                    break;

                case 3:
                    sair = true;
                    break;
            }
        }

        if (precisaAtualizar)
        {
            blit(titulo, buffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
            alfont_textout_centre_aa_ex(buffer, fontMenu, OPCAO_1, buffer->w / 2, ALTURA,                  (foco == 0 ? colorFocusOn : colorFocusOff), -1);
            alfont_textout_centre_aa_ex(buffer, fontMenu, OPCAO_2, buffer->w / 2, ALTURA + MENU_FONT_SIZE,     (foco == 1 ? colorFocusOn : colorFocusOff), -1);
            alfont_textout_centre_aa_ex(buffer, fontMenu, OPCAO_3, buffer->w / 2, ALTURA + MENU_FONT_SIZE * 2, (foco == 2 ? colorFocusOn : colorFocusOff), -1);
            alfont_textout_centre_aa_ex(buffer, fontMenu, OPCAO_4, buffer->w / 2, ALTURA + MENU_FONT_SIZE * 3, (foco == 3 ? colorFocusOn : colorFocusOff), -1);
            blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
            precisaAtualizar = false;
            rest(150);
        }
	}
	destroy_bitmap(buffer);
}

void CMenu::Apresentacao()
{
	BITMAP* logo = load_bmp(IMAGEM_APRESENTACAO, NULL);
	BITMAP* buffer = create_bitmap(SCREEN_W, SCREEN_H);

	clear_to_color(screen, makecol(255, 255, 255));
	blit(logo, screen, 0, 0, SCREEN_W / 2 - logo->w / 2, SCREEN_H / 2 - logo->h / 2, logo->w, logo->h);
	bool joypad_button_pressed = false;
    while(!keypressed() && !joypad_button_pressed)
    {
        poll_joystick();
        for (int c = 0; c < joy[0].num_buttons; c++)
        {
            if (joy[0].button[c].b)
                joypad_button_pressed = true;
        }
    }
    rest(150);
	clear_keybuf();
	joypad_button_pressed = false;
    for (int alpha = 254; alpha > 0; alpha--)
    {
    	poll_joystick();
        for (int c = 0; c < joy[0].num_buttons; c++)
        {
            if (joy[0].button[c].b)
                joypad_button_pressed = true;
        }
    	if (keypressed() || joypad_button_pressed)
    		alpha = 0;
        clear_to_color(buffer, makecol(255, 255, 255));
        set_trans_blender(0, 0, 0, alpha);
        draw_trans_sprite(buffer, logo, SCREEN_W / 2 - logo->w / 2, SCREEN_H / 2 - logo->h / 2);
        set_trans_blender(0, 0, 0, 255 - alpha);
        draw_trans_sprite(buffer, titulo, 0, 0);
        blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
        vsync();
    }
	destroy_bitmap(buffer);
	destroy_bitmap(logo);
	rest(150);
}

void CMenu::Credits()
{
	#define QUADRO_W 200
	#define QUADRO_H 300
	blit(titulo, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
	set_trans_blender(0, 0, 0, 128);
	rectfill(screen, SCREEN_W/2 - QUADRO_W/2, SCREEN_H/2 - QUADRO_H/2, SCREEN_W/2 + QUADRO_W/2, SCREEN_H/2 + QUADRO_H/2, 0); // desenha um retangulo preto
	alfont_set_font_size(fontMenu, 20);
	alfont_textout_centre_aa_ex(screen, fontMenu, "developer", SCREEN_W/ 2, SCREEN_H/2 - 90, makecol(0, 0, 0), -1);
	alfont_textout_centre_aa_ex(screen, fontMenu, "graphics", SCREEN_W/ 2, SCREEN_H/2 + 30, makecol(0, 0, 0), -1);
	alfont_set_font_size(fontMenu, MENU_FONT_SIZE);
	alfont_textout_centre_aa_ex(screen, fontMenu, "H8OR", SCREEN_W/ 2, SCREEN_H/2 - 70, colorFocusOff, -1);
	alfont_textout_centre_aa_ex(screen, fontMenu, "ASCII", SCREEN_W/ 2, SCREEN_H/2 + 50, colorFocusOff, -1);

	// Graphics = ASCII
	solid_mode();


	rest(150);
	clear_keybuf();
	bool joypad_button_pressed = false;
	while ( !keypressed() && !joypad_button_pressed )
	{
		poll_joystick();
		for (int c = 0; c < joy[0].num_buttons; c++)
        {
            if (joy[0].button[c].b)
                joypad_button_pressed = true;
        }
	}
}

void CMenu::Help()
{
}
