#include "listmap.h"

int InsertMap(const char *fileName, int atrib, void *objListMap)
{
    CMap *novoMapa = new CMap(fileName);
    ((CListMap*)objListMap)->mapas.push_back(novoMapa);
    return 0;
}

CListMap::CListMap()
{
    LoadFromDiretory();
    nextMap = 0;
}


CListMap::~CListMap()
{
    mapas.clear();
}

CMap* CListMap::operator[](const int posicao)
{
    return mapas[posicao];
}

void CListMap::LoadFromDiretory()
{
    numMaps = for_each_file_ex("./lev3/*.lev", 0, 0, InsertMap, (void*)this);
}

int CListMap::Next()
{
	int result = nextMap;
	if (++nextMap >= mapas.size())
		nextMap = 0;
	return result;
}

int CListMap::GetNextMap()
{
	return nextMap;
}

void CListMap::SetNextMap(int newNextMap)
{
	nextMap = newNextMap;
}
