#ifndef __HEROI__
#define __HEROI__

#include <allegro.h>
#include "room.h"

#define NUM_DIRECOES	4
#define NUM_FRAMES		4
#define TILE_SIZE		32

#define DIR_DOWN	0
#define DIR_LEFT	1
#define DIR_RIGHT	2
#define DIR_UP		3

#define STATE_STOP   0
#define STATE_MOVING 1

#define TL_FLOOR      0
#define TL_WALL       1
#define TL_SKULL      2
#define TL_BOX        4
#define TL_SKULL_BOX  6

class CHeroi
{
public:
    CHeroi(volatile unsigned int*);
	~CHeroi();
	void Draw(BITMAP*);
	int GetPosX();
	int GetPosY();

	void Move();

	void MoveUp();
	void MoveDown();
	void MoveLeft();
	void MoveRight();
    void Load(CRoom*);

    int state;

private:
	CRoom *room;
	BITMAP* charset[NUM_DIRECOES][NUM_FRAMES];
	int posX;
	int posY;
	int offset;
	int tileWidth;
	int tileHeight;
	int offsetBaseY;
	int offsetBaseX;

	int direcao;
	volatile unsigned int *gTime;

};


#endif // __HEROI__
