#include "heroi.h"

CHeroi::CHeroi(volatile unsigned int *enderecoTemporizador)
{
    gTime = enderecoTemporizador;
}

CHeroi::~CHeroi()
{
	// destruir o charset
	for (int linha = 0; linha < NUM_DIRECOES; linha++)
		for (int coluna = 0; coluna < NUM_FRAMES; coluna++)
			destroy_bitmap(charset[linha][coluna]);
}

void CHeroi::Load(CRoom* level)
{
	room = level;
	posX = room->playerCol;
    posY = room->playerRow;
    offset = 0;
    state = STATE_STOP;
    direcao = DIR_DOWN;
    BITMAP* charsetTemp = load_bmp(CRoom::charsetName.c_str(), NULL);
    tileWidth = charsetTemp->w / 4;
    tileHeight = charsetTemp->h / 4;
    for (int linha = 0; linha < NUM_DIRECOES; linha++)
		for (int coluna = 0; coluna < NUM_FRAMES; coluna++)
			charset[linha][coluna] = create_bitmap(tileWidth, tileHeight);

    offsetBaseX = (TILE_SIZE-tileWidth)/2;
    offsetBaseY = (TILE_SIZE-tileHeight);


	for (int linha = 0; linha < NUM_DIRECOES; linha++)
		for (int coluna = 0; coluna < NUM_FRAMES; coluna++)
            blit(charsetTemp, charset[linha][coluna], coluna * tileWidth, linha * tileHeight, 0, 0, tileWidth, tileHeight);

	destroy_bitmap(charsetTemp);
}

void CHeroi::Draw(BITMAP* activePage)
{
	if (direcao == DIR_UP)
		draw_sprite(activePage, charset[direcao][(*gTime / 16) % NUM_FRAMES], posX * 32 + offsetBaseX, posY * 32 - offset + offsetBaseY);
	else if (direcao == DIR_DOWN)
		draw_sprite(activePage, charset[direcao][(*gTime / 16) % NUM_FRAMES], posX * 32 + offsetBaseX, posY * 32 + offset + offsetBaseY);
	else if (direcao == DIR_LEFT)
		draw_sprite(activePage, charset[direcao][(*gTime / 16) % NUM_FRAMES], posX * 32 - offset + offsetBaseX, posY * 32 + offsetBaseY);
	else if (direcao == DIR_RIGHT)
		draw_sprite(activePage, charset[direcao][(*gTime / 16) % NUM_FRAMES], posX * 32 + offset + offsetBaseX, posY * 32 + offsetBaseY);
}


void CHeroi::Move()
{
	offset++;
	if (offset == 32 || offset == -32)
	{
		offset = 0;
		state = STATE_STOP;

		switch(direcao)
		{
			case DIR_UP:
				posY--;
				break;
			case DIR_DOWN:
				posY++;
				break;
			case DIR_LEFT:
				posX--;
				break;
			case DIR_RIGHT:
				posX++;
				break;
		}

	}
}

void CHeroi::MoveUp()
{
	// verifica se pode
	if (!(room->matrix[posY-1][posX] & 5))
	{
		state = STATE_MOVING;
		direcao = DIR_UP;
	}
	if (room->matrix[posY-1][posX] & TL_BOX && !(room->matrix[posY-2][posX] & 5))
	{
		state = STATE_MOVING;
		direcao = DIR_UP;
		room->Push(posY-1, posX, direcao);
	}
}

void CHeroi::MoveDown()
{
	if (!(room->matrix[posY+1][posX] & 5))
	{
		state = STATE_MOVING;
		direcao = DIR_DOWN;
	}
	if (room->matrix[posY+1][posX] & TL_BOX && !(room->matrix[posY+2][posX] & 5))
	{
		state = STATE_MOVING;
		direcao = DIR_DOWN;
		room->Push(posY+1, posX, direcao);
	}
}

void CHeroi::MoveLeft()
{
	if (!(room->matrix[posY][posX-1] & 5))
	{
		state = STATE_MOVING;
		direcao = DIR_LEFT;
	}
	if (room->matrix[posY][posX-1] & TL_BOX && !(room->matrix[posY][posX-2] & 5))
	{
		state = STATE_MOVING;
		direcao = DIR_LEFT;
		room->Push(posY, posX-1, direcao);

	}
}

void CHeroi::MoveRight()
{
	if (!(room->matrix[posY][posX+1] & 5))
	{
		state = STATE_MOVING;
		direcao = DIR_RIGHT;
		return;
	}
	if (room->matrix[posY][posX+1] & TL_BOX && !(room->matrix[posY][posX+2] & 5))
	{
		state = STATE_MOVING;
		direcao = DIR_RIGHT;
		room->Push(posY, posX+1, direcao);
	}
}

int CHeroi::GetPosX()
{
	return posX;
}
int CHeroi::GetPosY()
{
	return posY;
}
