#ifndef __GKERNEL__
#define __GKERNEL__

#include <allegro.h>
#include <alfont.h>
#include "heroi.h"
#include "listmap.h"
#include "room.h"
#include "options.h"

#define KERNEL_FPSQ 96
#define KERNEL_FONT_NAME "res/Negatori.ttf"
#define KERNEL_FONT_SIZE 20

/*! \class CGKernel
 * \brief Ncleo do jogo. Cria e destri todos os recursos.
 * \date 2007-06-07-00.37
 */
class CGKernel
{
public:
    CGKernel(COptions*);
    ~CGKernel();
    void Go(int);
    IListMap* mapas;

private:
	COptions* options;
	ALFONT_FONT* gfont;
	CHeroi* heroi;
	CRoom *room;
    bool gameOver;
    BITMAP* activePage;

    void UpdateLogic();
    void UpdateScreen();
};

#endif // __GKERNEL__
