#include "gkernel.h"
#include "ListMapH8OR.h"
#include "ListMapXml.h"

static volatile int speedCounter = 0;
static volatile unsigned int gTime = 0;

static void IncrementSpeedCounter()
{
    speedCounter++;
    gTime++;
}
END_OF_FUNCTION(IncrementSpeedCounter);


CGKernel::CGKernel(COptions* newOptions):
        options(newOptions)
{
    LOCK_VARIABLE(speedCounter);
    LOCK_FUNCTION(IncrementSpeedCounter);
    install_int_ex(IncrementSpeedCounter, BPS_TO_TIMER(KERNEL_FPSQ));
    gfont = alfont_load_font(KERNEL_FONT_NAME);
    alfont_set_font_size(gfont, KERNEL_FONT_SIZE);
    activePage = create_bitmap(SCREEN_W, SCREEN_H);
}



CGKernel::~CGKernel()
{
    destroy_bitmap(activePage);
    alfont_destroy_font(gfont);
    remove_int(IncrementSpeedCounter);
}


/*! O loop principal do jogo.
 */
void CGKernel::Go(int numLevel = 0)
{
    mapas = new ListMapXml(options->GetFilename().c_str());
    heroi = new CHeroi(&gTime);
    gameOver = false;

    CRoom::tilesetName = options->GetTileset();
    CRoom::charsetName = options->GetCharset();

    mapas->SetNextMap(numLevel);
    room = new CRoom((*mapas)[mapas->Next()]);
    clear_to_color(activePage, 0);

    heroi->Load(room);
    speedCounter = 0;
    while (!gameOver)
    {
        while (speedCounter > 0)
        {
            UpdateLogic();
            speedCounter--;
            if (room->IsWinner())
            {
                clear_to_color(activePage, 0);
                int nextMap = mapas->GetNextMap();
                if ( nextMap != 0 )
                    options->SetLastLevel(nextMap);

                delete room;
                room = new CRoom((*mapas)[mapas->Next()]);
                heroi->Load(room);
                speedCounter = 0;
                rest(150);
            }
        }
        UpdateScreen();
    }
    delete room;
    delete heroi;
    delete mapas;
}


/// Responsvel pela lgica principal do jogo.
/*! L a entrada de dados do teclado e joystick, depois toma decises
 * baseados nessas informaes e o estado atual do jogo.
 */
void CGKernel::UpdateLogic()
{
    poll_joystick();
    if (key[KEY_ESC] || joy[0].button[1].b)
        gameOver = true;

    if (key[KEY_SPACE] || key[KEY_R] || joy[0].button[0].b)
    {
        room->Load();
        heroi->Load(room);
    }

    if (heroi->state == STATE_MOVING)
    {
        heroi->Move();
    }
    else
    {
        if (key[KEY_UP] || joy[0].stick[0].axis[1].d1)
            heroi->MoveUp();
        else if (key[KEY_DOWN] || joy[0].stick[0].axis[1].d2)
            heroi->MoveDown();
        else if (key[KEY_LEFT] || joy[0].stick[0].axis[0].d1)
            heroi->MoveLeft();
        else if (key[KEY_RIGHT] || joy[0].stick[0].axis[0].d2)
            heroi->MoveRight();
    }
    room->UpdateLogic();
}

void CGKernel::UpdateScreen()
{
    room->Draw(activePage, heroi->GetPosY(), heroi->GetPosX());
    heroi->Draw(activePage);
    blit(activePage, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}
