#include "sokoban.h"

#define TL_FLOOR      0
#define TL_WALL       1
#define TL_SKULL      2
#define TL_BOX        4
#define TL_SKULL_BOX  6


//! Default constructor
Sokoban::Sokoban()
{}
//! Default destructor
Sokoban::~Sokoban()
{}

//!	Initialize a level
void Sokoban::Init(int **_matrix, int _rows, int _cols)
{
	matrix = _matrix;
	rows = _rows;
	cols = _cols;
}


bool Sokoban::MoveUp()
{
	if (matrix[playerRow-1][playerCol] & 5)
		return false;
	if (matrix[playerRow-1][playerCol] & TL_BOX && !(matrix[playerRow-2][playerCol] & 5))
	{
		matrix[playerRow-1][playerCol] &= ~TL_BOX; // apagar a caixa
		matrix[playerRow-2][playerCol] |= TL_BOX; // criar a nova caixa no lugar certo
	}
	playerRow--;
	return true;
}

bool Sokoban::MoveDown()
{
	if (matrix[playerRow+1][playerCol] & 5)
		return false;
	if (matrix[playerRow+1][playerCol] & TL_BOX && !(matrix[playerRow+2][playerCol] & 5))
	{
		matrix[playerRow+1][playerCol] &= ~TL_BOX; // apagar a caixa
		matrix[playerRow+2][playerCol] |= TL_BOX; // criar a nova caixa no lugar certo
	}
	playerRow++;
	return true;
}

bool Sokoban::MoveLeft()
{
	if (matrix[playerRow][playerCol-1] & 5)
		return false;
	if (matrix[playerRow][playerCol-1] & TL_BOX && !(matrix[playerRow][playerCol-2] & 5))
	{
		matrix[playerRow][playerCol-1] &= ~TL_BOX; // apagar a caixa
		matrix[playerRow][playerCol-2] |= TL_BOX; // criar a nova caixa no lugar certo
	}
	playerCol--;
	return true;
}

bool Sokoban::MoveRight()
{
	if (matrix[playerRow][playerCol+1] & 5)
		return false;
	if (matrix[playerRow][playerCol+1] & TL_BOX && !(matrix[playerRow][playerCol+2] & 5))
	{
		matrix[playerRow][playerCol+1] &= ~TL_BOX; // apagar a caixa
		matrix[playerRow][playerCol+2] |= TL_BOX; // criar a nova caixa no lugar certo
	}
	playerCol++;
	return true;
}

bool Sokoban::IsWinner()
{
    for (int row = 0; row < rows; row++)
        for (int col = 0; col < cols; col++)
            if (matrix[row][col] == TL_SKULL)
                return false;
    return true;
}
