#ifndef LISTMAPXML_H_INCLUDED
#define LISTMAPXML_H_INCLUDED

#include <vector>
#include <string>
#include "listmap.h"

/*! \class ListMapXml
 * \brief Container que armazena os cenrios do jogo.
 *
 * Interpreta o formato padro slc, que  um xml.
 * \date 2007-06-08-00.52
 */
class ListMapXml : public IListMap
{
public:
	int numMaps;
    std::vector<CMap*> mapas;  // vetor de ponteiros para CMap

    ListMapXml();
    ListMapXml(const char* fileName);
    ~ListMapXml();
    CMap* operator[](const int);
    int Next();
    int GetNextMap();
    void SetNextMap(int);

	void LoadMaps(const char* fileName);
    int GetNumMaps();

	std::string title;
    std::string description;
    std::string author;


private:

    int nextMap;

};


#endif // LISTMAPXML_H_INCLUDED
